% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PV.BR.r
\name{PV.BR}
\alias{PV.BR}
\title{Function to compute PPV and NPV with specified base rates}
\usage{
PV.BR(outcome, predictor,cut.off='max.Youden', BR=1)
}
\arguments{
\item{outcome}{The outcome variable indicating the status in the form of a data frame or matrix. 
This variable is typically coded as 0 (positive) and 1 (negative).}

\item{predictor}{A numerical vector of scores used to predict the status of the outcome. This variable 
should be of the same length as the outcome variable (i.e., two variables are 
from the same data set and also of the same number of data rows).}

\item{cut.off}{Specification of the criterion used to select the optimal cut score. 
Three options available: (1) 'max.Youden' returns the cut score that maximizes the Youden Index (the default);
(2) 'max.sen' returns the cut score that maximizes the sensitivity; and (3) 'max.spe' returns
the cut score that maximizes the specificity.}

\item{BR}{Base rates or known prevalence. Multiple values can be specified simultaneously. 
By default BR=1.}
}
\value{
An object that contains results of classification statistics.
\item{Result}{
 * Cut.off, the optimal cut score.\cr
 * Sensitivity, also true positive rate, the y-axis of the ROC.\cr
 * Specificity, also true negative rate. \cr
 * Youden.Index. \cr
 * PPV or positive predictive value for each specified base rate.\cr
 * NPV or negative predictive value for each specified base rate.\cr
 * PPV for the sample.\cr
 * NPV for the sample.}
}
\description{
This function computes positive predictive values (PPV) and negative predictive values (NPV)
 with provided base rates (or known prevalence).
}
\examples{
 
#read the example data
data(ROC.data.ex)
#run the function
PV.BR(ROC.data.ex$outcome, ROC.data.ex$predictor,
      cut.off='max.Youden', BR=1)
}
\references{
{
 McCaffrey R.J., Palav A.A., O’Bryant S.E., Labarge A.S. (2003). 
"A Brief Overview of Base Rates. 
In: McCaffrey R.J., Palav A.A., O’Bryant S.E., Labarge A.S. (eds) 
Practitioner’s Guide to Symptom Base Rates in Clinical Neuropsychology. Critical Issues in Neuropsychology. ."
Springer, Boston, MA. doi:10.1007/978-1-4615-0079-7_1. 
}
}
