% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nifti.R
\name{readNifti}
\alias{readNifti}
\alias{readAnalyze}
\title{Read NIfTI or ANALYZE format files}
\usage{
readNifti(file, internal = FALSE, volumes = NULL)
}
\arguments{
\item{file}{A character vector of file names.}

\item{internal}{Logical value. If \code{FALSE} (the default), an array
of class \code{"niftiImage"}, containing the image pixel or voxel values,
will be returned. If \code{TRUE}, the return value will be an object of
class \code{"internalImage"}, which contains only minimal metadata about
the image. Either way, the return value has an attribute which points to a
C data structure containing the full image.}

\item{volumes}{An integer vector giving the volumes to read (counting along
all dimensions beyond the third jointly), or \code{NULL}, the default, in
which case every volume is read. This cannot currently be set differently
for each file read.}
}
\value{
An array or internal image, with class \code{"niftiImage"} (and
  possibly also \code{"internalImage"}), or a list of such objects if
  \code{file} has length greater than one.
}
\description{
This function reads one or more NIfTI-1, NIfTI-2 or ANALYZE-7.5 files into
R, using the standard NIfTI C library.
}
\note{
If the \code{internal} argument is \code{FALSE} (the default), the
  data type of the image pointer will be set to match one of R's native
  numeric data types, i.e., 32-bit signed integer or 64-bit double-precision
  floating-point. In these circumstances the data type reported by the
  \code{\link{niftiHeader}} function will therefore not, in general, match
  the storage type used in the file. See also the \code{datatype} argument
  to \code{\link{writeNifti}}.
}
\examples{
path <- system.file("extdata", "example.nii.gz", package="RNifti")
readNifti(path)
readNifti(path, internal=TRUE)

}
\references{
The NIfTI-1 standard (\url{http://www.nitrc.org/docman/view.php/26/64/nifti1.h}).
}
\seealso{
\code{\link{writeNifti}}
}
\author{
Jon Clayden <code@clayden.org>
}
