% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RankNormal.R
\name{IINT}
\alias{IINT}
\title{Indirect-INT}
\usage{
IINT(y, G, X, S, calcP = T, k = 3/8, parallel = F, check = T)
}
\arguments{
\item{y}{Numeric phenotype vector.}

\item{G}{Snp by obs genotype matrix.}

\item{X}{Obs by feature covariate matrix.}

\item{S}{Obs by feature structure matrix.}

\item{calcP}{Logical indicating that p values should be calculated.}

\item{k}{Offset applied during rank-normalization. See \code{\link{rankNormal}}.}

\item{parallel}{Logical indicating whether to run in parallel. Must register
parallel backend first.}

\item{check}{Logical indicating whether to check the input.}
}
\value{
A numeric vector of p-values assessing the null hypothesis of no 
  genotypic effect. P-values are estimated using the Wald statistic, and 
  correspond to the rows of G.
}
\description{
Two-stage regression procedure. In the first stage, phenotype is regressed on
covariates to obtain residuals. In the second stage, INT-transformed
residuals are regressed on genotype and population structure.
}
\examples{
# IINT against normal phenotype
p = RNOmni::IINT(y=RNOmni::Y[,1],G=RNOmni::G[1:10,],X=RNOmni::X,S=RNOmni::S);
}
