% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMVL.R
\name{mvl_inherits}
\alias{mvl_inherits}
\title{Check inheritance of R or MVL objects}
\usage{
mvl_inherits(x, clstr, which = FALSE)
}
\arguments{
\item{x}{any object}

\item{clstr}{classes to match against}

\item{which}{when TRUE return a boolean array indicating of which classes named in \code{clstr} are inherited by x. When FALSE return a single boolean indicating inheritance of any class named in \code{clstr}.}
}
\value{
character string giving object class
}
\description{
This functions works just like the usual R \code{inherits()}, except that it takes MVL_OBJECT class into account.
For non-MVL objects the function simply calls the usual R \code{inherit()}, so it can be used instead of \code{inherit()} for code that operates on both usual R objects and MVL objects.
}
