/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.api;

import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.Observation;
import it.bancaditalia.oss.sdmx.api.ObservationIterator;
import it.bancaditalia.oss.sdmx.exceptions.DataStructureException;
import it.bancaditalia.oss.sdmx.util.Configuration;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class PortableTimeSeries
implements Serializable,
Iterable<Observation> {
    private static final long serialVersionUID = 1L;
    public static final String GENERATEDNAME_ATTR_NAME = "CONNECTORS_AUTONAME";
    protected static final Logger logger = Configuration.getSdmxLogger();
    private String frequency = null;
    private Dataflow dataflow = null;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final Map<String, Map.Entry<String, String>> dimensions = new LinkedHashMap<String, Map.Entry<String, String>>();
    private List<String> timeSlots = new ArrayList<String>();
    private List<String> observations = new ArrayList<String>();
    final List<String> status = new ArrayList<String>();
    final Map<String, List<String>> obsLevelAttributes = new HashMap<String, List<String>>();
    private boolean errorFlag = false;
    private boolean numeric = true;
    private String errorMessage = null;
    private String name;
    private boolean useGeneratedName = true;

    public Map<String, String> getAttributesMap() {
        if (!this.attributes.containsKey(GENERATEDNAME_ATTR_NAME) && this.dataflow != null && this.dataflow.getName() != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.dataflow != null && this.dataflow.getName() != null && !this.dataflow.getName().isEmpty()) {
                stringBuilder.append(this.dataflow.getName());
            }
            for (Map.Entry<String, String> entry : this.dimensions.values()) {
                stringBuilder.append(", " + entry.getKey() + "(" + (entry.getValue() != null ? entry.getValue() : "") + ")");
            }
            this.attributes.put(GENERATEDNAME_ATTR_NAME, stringBuilder.toString());
        }
        return this.attributes;
    }

    public String[] getAttributeNamesArray() {
        return this.getAttributesMap().keySet().toArray(new String[0]);
    }

    public String getAttribute(String string) {
        return this.getAttributesMap().get(string);
    }

    public void setAttributes(Map<String, String> map) {
        this.getAttributesMap().clear();
        this.getAttributesMap().putAll(map);
    }

    public void addAttribute(String string, String string2) {
        this.getAttributesMap().put(string, string2);
    }

    public Map<String, String> getDimensionsMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Map.Entry<String, String>> entry : this.dimensions.entrySet()) {
            linkedHashMap.put(entry.getKey(), Configuration.getCodesPolicy().equalsIgnoreCase("description") ? entry.getValue().getValue() : entry.getValue().getKey());
        }
        return linkedHashMap;
    }

    public String[] getDimensionNamesArray() {
        return this.dimensions.keySet().toArray(new String[0]);
    }

    public String getDimension(String string) {
        return this.dimensions.containsKey(string) ? this.dimensions.get(string).getKey() : null;
    }

    public void setDimensions(Map<String, Map.Entry<String, String>> map) {
        this.dimensions.clear();
        this.dimensions.putAll(map);
        this.attributes.remove(GENERATEDNAME_ATTR_NAME);
        if (this.useGeneratedName) {
            this.name = null;
        }
    }

    public void addDimension(String string, String string2) {
        this.dimensions.put(string, new AbstractMap.SimpleEntry<String, Object>(string2, null));
        this.attributes.remove(GENERATEDNAME_ATTR_NAME);
        if (this.useGeneratedName) {
            this.name = null;
        }
    }

    public void addObservation(String string, String string2, Map<String, String> map) {
        if (string == null || string.isEmpty()) {
            logger.info(this.getName() + ": missing observation for time slot: " + string2 + ", I'll set a NaN.");
            this.observations.add("NaN");
        } else {
            this.observations.add(string);
        }
        if (string2 == null || string2.isEmpty()) {
            logger.info(this.getName() + ": a time slot is missing. This is not a well formed time series. I'll set a blank character.");
            string2 = "";
        }
        this.timeSlots.add(string2);
        if (map != null) {
            for (String object : map.keySet()) {
                if (object.equals("OBS_STATUS")) {
                    this.status.add(map.get(object));
                }
                if (this.obsLevelAttributes.containsKey(object)) {
                    this.obsLevelAttributes.get(object).add(map.get(object));
                    continue;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < this.timeSlots.size() - 1; ++i) {
                    arrayList.add("");
                }
                arrayList.add(map.get(object));
                this.obsLevelAttributes.put(object, arrayList);
            }
        }
        if (this.obsLevelAttributes != null) {
            for (ArrayList arrayList : this.obsLevelAttributes.values()) {
                if (arrayList.size() >= this.timeSlots.size()) continue;
                arrayList.add("");
            }
        }
    }

    public void setObservations(List<String> list) throws DataStructureException {
        if (list.size() != this.timeSlots.size()) {
            throw new DataStructureException("Error setting data in time series. Wrong observation number.");
        }
        this.observations = list;
    }

    public List<Object> getObservations() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.isNumeric()) {
            for (String string : this.observations) {
                try {
                    arrayList.add(Double.valueOf(string));
                }
                catch (NumberFormatException numberFormatException) {
                    logger.info(this.getName() + ": found invalid observation for time series: " + this.getName() + ", I'll set a NaN.");
                    arrayList.add(new Double("NaN"));
                }
            }
        } else {
            for (String string : this.observations) {
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public Object[] getObservationsArray() throws DataStructureException {
        if (this.isNumeric()) {
            return this.getObservations().toArray(new Double[0]);
        }
        return this.getObservations().toArray(new String[0]);
    }

    public void setTimeSlots(List<String> list) throws DataStructureException {
        if (list.size() != this.observations.size()) {
            throw new DataStructureException("Error setting dates in time series. Wrong dates number.");
        }
        this.timeSlots = list;
    }

    public List<String> getTimeSlots() {
        return this.timeSlots;
    }

    public String[] getTimeSlotsArray() {
        return this.timeSlots.toArray(new String[0]);
    }

    public List<String> getObsLevelAttributesNames() {
        return new ArrayList<String>(this.obsLevelAttributes.keySet());
    }

    public String[] getObsLevelAttributesNamesArray() {
        return this.getObsLevelAttributesNames().toArray(new String[0]);
    }

    public List<String> getObsLevelAttributes(String string) {
        return this.obsLevelAttributes.get(string);
    }

    public String[] getObsLevelAttributesArray(String string) {
        return this.getObsLevelAttributes(string).toArray(new String[0]);
    }

    public String getName() {
        if (this.useGeneratedName && this.name == null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.dataflow != null && this.dataflow.getId() != null && !this.dataflow.getId().isEmpty()) {
                stringBuilder.append(this.dataflow.getId() + ".");
            }
            for (Map.Entry<String, String> entry : this.dimensions.values()) {
                stringBuilder.append((Configuration.getCodesPolicy().equalsIgnoreCase("description") ? entry.getValue() : entry.getKey()) + ".");
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            this.name = stringBuilder.toString();
        }
        return this.name;
    }

    public void setName(String string) {
        this.useGeneratedName = false;
        this.name = string;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String string) {
        this.frequency = string;
    }

    public String getDataflow() {
        return this.dataflow.getId();
    }

    public Dataflow getDataflowObject() {
        return this.dataflow;
    }

    public void setDataflow(Dataflow dataflow) {
        this.dataflow = dataflow;
    }

    public boolean isErrorFlag() {
        return this.errorFlag;
    }

    public void setErrorFlag(boolean bl) {
        this.errorFlag = bl;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    @Override
    public Iterator<Observation> iterator() {
        return new ObservationIterator(this);
    }

    public void reverse() {
        Collections.reverse(this.observations);
        Collections.reverse(this.timeSlots);
        for (String string : this.obsLevelAttributes.keySet()) {
            List<String> list = this.obsLevelAttributes.get(string);
            Collections.reverse(list);
            this.obsLevelAttributes.put(string, list);
        }
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public void setNumeric(boolean bl) {
        this.numeric = bl;
    }

    public String toString() {
        String string = "";
        string = string + "\nName: " + this.getName();
        string = string + "\nFrequency: " + this.frequency;
        string = string + "\nnumeric: " + this.numeric;
        string = string + "\nerror: " + this.isErrorFlag();
        string = string + "\nerror_msg: " + this.getErrorMessage();
        string = string + "\nAttributes: " + this.getAttributesMap();
        string = string + "\nDimensions: " + this.getDimensionsMap();
        string = string + "\nVALUES: ";
        string = string + this.observations;
        string = string + "\nTIMES:";
        string = string + this.timeSlots;
        string = string + "\nOBSERVATION ATTRIBUTES:";
        string = string + this.obsLevelAttributes;
        return string;
    }

    @Deprecated
    public List<String> getAttributes() {
        return Arrays.asList(this.getAttributesArray());
    }

    @Deprecated
    public String getAttributeValue(String string) {
        return this.getAttribute(string);
    }

    @Deprecated
    public String[] getAttributesArray() {
        String[] stringArray = new String[this.getAttributesMap().size()];
        int n = 0;
        for (Map.Entry<String, String> entry : this.getAttributesMap().entrySet()) {
            stringArray[n++] = entry.getKey() + "=" + entry.getValue();
        }
        return stringArray;
    }

    @Deprecated
    public void setAttributes(List<String> list) {
        this.getAttributesMap().clear();
        for (String string : list) {
            this.getAttributesMap().put(string.split("=")[0], string.split("=")[1]);
        }
    }

    @Deprecated
    public void addAttribute(String string) {
        this.addAttribute(string.split("=")[0], string.split("=")[1]);
    }

    @Deprecated
    public List<String> getDimensions() {
        return Arrays.asList(this.getDimensionsArray());
    }

    @Deprecated
    public String getDimensionValue(String string) {
        return this.getDimension(string);
    }

    @Deprecated
    public String[] getDimensionsArray() {
        String[] stringArray = new String[this.dimensions.size()];
        int n = 0;
        for (Map.Entry<String, Map.Entry<String, String>> entry : this.dimensions.entrySet()) {
            stringArray[n++] = entry.getKey() + "=" + entry.getValue().getKey();
        }
        return stringArray;
    }

    @Deprecated
    public void addDimension(String string) {
        this.addDimension(string.split("=")[0], string.split("=")[1]);
    }

    @Deprecated
    public List<String> getStatus() {
        return this.status;
    }

    @Deprecated
    public String[] getStatusArray() {
        return this.status.toArray(new String[0]);
    }
}

