/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client;

import it.bancaditalia.oss.sdmx.api.DSDIdentifier;
import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.GenericSDMXClient;
import it.bancaditalia.oss.sdmx.api.Message;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxExceptionFactory;
import it.bancaditalia.oss.sdmx.exceptions.SdmxInvalidParameterException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxXmlContentException;
import it.bancaditalia.oss.sdmx.parser.v21.CodelistParser;
import it.bancaditalia.oss.sdmx.parser.v21.CompactDataParser;
import it.bancaditalia.oss.sdmx.parser.v21.DataParsingResult;
import it.bancaditalia.oss.sdmx.parser.v21.DataStructureParser;
import it.bancaditalia.oss.sdmx.parser.v21.DataflowParser;
import it.bancaditalia.oss.sdmx.parser.v21.RestQueryBuilder;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.DisconnectOnCloseReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.xml.bind.DatatypeConverter;
import javax.xml.stream.XMLStreamException;

public class RestSdmxClient
implements GenericSDMXClient {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    protected boolean dotStat = false;
    protected URL endpoint = null;
    protected String name = null;
    protected boolean needsCredentials = false;
    protected boolean needsURLEncoding = false;
    protected boolean supportsCompression = false;
    protected boolean containsCredentials = false;
    protected String user = null;
    protected String pw = null;
    protected int readTimeout = Configuration.getReadTimeout(this.getClass().getSimpleName());
    protected int connectTimeout = Configuration.getConnectTimeout(this.getClass().getSimpleName());
    private static final String sourceClass = RestSdmxClient.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();

    public RestSdmxClient(String string, URL uRL, boolean bl, boolean bl2, boolean bl3) {
        this.endpoint = uRL;
        this.name = string;
        this.needsCredentials = bl;
        this.needsURLEncoding = bl2;
        this.supportsCompression = bl3;
    }

    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    public void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    @Override
    public Map<String, Dataflow> getDataflows() throws SdmxException {
        HashMap<String, Dataflow> hashMap;
        block12: {
            String string = null;
            Reader reader = null;
            hashMap = null;
            string = this.buildFlowQuery("all", "all", "latest");
            try {
                reader = this.runQuery(string, null);
                List<Dataflow> list = DataflowParser.parse(reader);
                if (list.size() > 0) {
                    hashMap = new HashMap<String, Dataflow>();
                    for (Dataflow dataflow : list) {
                        hashMap.put(dataflow.getId(), dataflow);
                    }
                    break block12;
                }
                throw new SdmxXmlContentException("The query returned zero dataflows");
            }
            catch (XMLStreamException xMLStreamException) {
                logger.severe("Exception caught parsing results from call to provider " + this.name);
                logger.log(Level.FINER, "Exception: ", xMLStreamException);
                throw SdmxExceptionFactory.wrap(xMLStreamException);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        logger.severe("Exception caught closing stream.");
                    }
                }
            }
        }
        return hashMap;
    }

    @Override
    public Dataflow getDataflow(String string, String string2, String string3) throws SdmxException {
        Dataflow dataflow;
        block11: {
            String string4 = null;
            Reader reader = null;
            dataflow = null;
            string4 = this.buildFlowQuery(string, string2, string3);
            try {
                reader = this.runQuery(string4, null);
                List<Dataflow> list = DataflowParser.parse(reader);
                if (list.size() >= 1) {
                    dataflow = list.get(0);
                    break block11;
                }
                throw new SdmxXmlContentException("The query returned zero dataflows");
            }
            catch (XMLStreamException xMLStreamException) {
                logger.severe("Exception caught parsing results from call to provider " + this.name);
                logger.log(Level.FINER, "Exception: ", xMLStreamException);
                throw SdmxExceptionFactory.wrap(xMLStreamException);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        logger.severe("Exception caught closing stream.");
                    }
                }
            }
        }
        return dataflow;
    }

    @Override
    public DataFlowStructure getDataFlowStructure(DSDIdentifier dSDIdentifier, boolean bl) throws SdmxException {
        String string = null;
        Reader reader = null;
        DataFlowStructure dataFlowStructure = null;
        if (dSDIdentifier == null) {
            throw new SdmxInvalidParameterException("getDataFlowStructure(): Null dsd in input");
        }
        if (dSDIdentifier != null) {
            string = this.buildDSDQuery(dSDIdentifier.getId(), dSDIdentifier.getAgency(), dSDIdentifier.getVersion(), bl);
            try {
                reader = this.runQuery(string, null);
                dataFlowStructure = DataStructureParser.parse(reader).get(0);
            }
            catch (XMLStreamException xMLStreamException) {
                logger.severe("Exception caught parsing results from call to provider " + this.name);
                logger.log(Level.FINER, "Exception: ", xMLStreamException);
                throw SdmxExceptionFactory.wrap(xMLStreamException);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        logger.severe("Exception caught closing stream.");
                    }
                }
            }
        }
        return dataFlowStructure;
    }

    @Override
    public Map<String, String> getCodes(String string, String string2, String string3) throws SdmxException {
        String string4 = null;
        Reader reader = null;
        Map<String, String> map = null;
        string4 = this.buildCodelistQuery(string, string2, string3);
        try {
            reader = this.runQuery(string4, null);
            map = CodelistParser.parse(reader);
        }
        catch (XMLStreamException xMLStreamException) {
            logger.severe("Exception caught parsing results from call to provider " + this.name);
            logger.log(Level.FINER, "Exception: ", xMLStreamException);
            throw SdmxExceptionFactory.wrap(xMLStreamException);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    logger.severe("Exception caught closing stream.");
                }
            }
        }
        return map;
    }

    @Override
    public List<PortableTimeSeries> getTimeSeries(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        DataParsingResult dataParsingResult = this.getData(dataflow, dataFlowStructure, string, string2, string3, bl, string4, bl2);
        return dataParsingResult.getData();
    }

    protected DataParsingResult getData(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        String string5 = null;
        Reader reader = null;
        DataParsingResult dataParsingResult = new DataParsingResult();
        string5 = this.buildDataQuery(dataflow, string, string2, string3, bl, string4, bl2);
        try {
            reader = this.runQuery(string5, "application/vnd.sdmx.structurespecificdata+xml;version=2.1");
            dataParsingResult = CompactDataParser.parse(reader, dataFlowStructure, dataflow.getId(), !bl);
            Message message = dataParsingResult.getMessage();
            if (message != null) {
                logger.info("The sdmx call returned messages in the footer:\n " + message.toString());
            }
        }
        catch (SdmxException sdmxException) {
            throw sdmxException;
        }
        catch (XMLStreamException xMLStreamException) {
            logger.severe("Exception caught parsing results from call to provider " + this.name);
            logger.log(Level.FINER, "Exception: ", xMLStreamException);
            throw SdmxExceptionFactory.wrap(xMLStreamException);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    logger.severe("Exception caught closing stream.");
                }
            }
        }
        return dataParsingResult;
    }

    @Override
    public boolean needsCredentials() {
        return this.needsCredentials;
    }

    @Override
    public void setCredentials(String string, String string2) {
        this.user = string;
        this.pw = string2;
        this.needsCredentials = false;
        this.containsCredentials = true;
    }

    @Override
    public URL getEndpoint() {
        return this.endpoint;
    }

    @Override
    public void setEndpoint(URL uRL) {
        this.endpoint = uRL;
    }

    @Override
    public String buildDataURL(Dataflow dataflow, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        return this.buildDataQuery(dataflow, string, string2, string3, bl, string4, bl2);
    }

    protected Reader runQuery(String string, String string2) throws SdmxException {
        logger.entering(sourceClass, "runQuery");
        if (this.needsURLEncoding) {
            string = string.replace("|", "%2B");
            string = string.replace("+", "%2B");
        }
        HttpURLConnection httpURLConnection = null;
        logger.info("Contacting web service with query: " + string);
        try {
            String string3;
            URL uRL = new URL(string);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setReadTimeout(this.readTimeout);
            httpURLConnection.setConnectTimeout(this.connectTimeout);
            this.handleHttpHeaders(httpURLConnection, string2);
            int n = httpURLConnection.getResponseCode();
            String string4 = string3 = httpURLConnection.getContentEncoding() == null ? "" : httpURLConnection.getContentEncoding();
            if (n == 200) {
                logger.fine("Connection opened. Code: " + n);
                InputStream inputStream = httpURLConnection.getInputStream();
                boolean bl = this.supportsCompression || string3.equalsIgnoreCase("gzip");
                return DisconnectOnCloseReader.of(bl ? new GZIPInputStream(inputStream) : inputStream, UTF_8, httpURLConnection);
            }
            SdmxException sdmxException = SdmxExceptionFactory.createRestException(n, null, null);
            logger.severe(sdmxException.getMessage());
            httpURLConnection.disconnect();
            throw sdmxException;
        }
        catch (IOException iOException) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            logger.severe("Exception. Class: " + iOException.getClass().getName() + " .Message: " + iOException.getMessage());
            logger.log(Level.FINER, "Exception: ", iOException);
            throw SdmxExceptionFactory.wrap(iOException);
        }
    }

    protected void handleHttpHeaders(HttpURLConnection httpURLConnection, String string) {
        if (this.containsCredentials) {
            logger.fine("Setting http authorization");
            String string2 = DatatypeConverter.printBase64Binary((byte[])(this.user + ":" + this.pw).getBytes());
            httpURLConnection.setRequestProperty("Authorization", "Basic " + string2);
        }
        if (this.supportsCompression) {
            httpURLConnection.addRequestProperty("Accept-Encoding", "gzip");
        }
        if (string != null) {
            httpURLConnection.setRequestProperty("Accept", string);
        }
    }

    protected String buildDataQuery(Dataflow dataflow, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        if (this.endpoint != null && dataflow != null && string != null && !string.isEmpty()) {
            String string5 = RestQueryBuilder.getDataQuery(this.endpoint, dataflow.getFullIdentifier(), string, string2, string3, bl, string4, bl2, null);
            return string5;
        }
        throw new RuntimeException("Invalid query parameters: dataflow=" + dataflow + " resource=" + string + " endpoint=" + this.endpoint);
    }

    protected String buildDSDQuery(String string, String string2, String string3, boolean bl) throws SdmxException {
        if (this.endpoint != null && string2 != null && !string2.isEmpty() && string != null && !string.isEmpty()) {
            String string4 = RestQueryBuilder.getStructureQuery(this.endpoint, string, string2, string3, bl);
            return string4;
        }
        throw new RuntimeException("Invalid query parameters: agency=" + string2 + " dsd=" + string + " endpoint=" + this.endpoint);
    }

    protected String buildFlowQuery(String string, String string2, String string3) throws SdmxException {
        String string4 = RestQueryBuilder.getDataflowQuery(this.endpoint, string, string2, string3);
        return string4;
    }

    protected String buildCodelistQuery(String string, String string2, String string3) throws SdmxException {
        String string4 = RestQueryBuilder.getCodelistQuery(this.endpoint, string, string2, string3);
        return string4;
    }
}

