/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.parser.v21;

import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.parser.v20.GenericDataParser;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.LocalizedText;
import it.bancaditalia.oss.sdmx.util.SdmxException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class CompactDataParser {
    private static final String sourceClass = CompactDataParser.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();
    private static final String MESSAGE = "Message";
    private static final String CODE = "code";
    private static final String SEVERITY = "severity";
    private static final String DATASET = "DataSet";
    private static final String ACTION = "action";
    private static final String VALID_FROM = "validFromDate";
    private static final String VALID_TO = "validToDate";
    private static final String SERIES = "Series";
    private static final String OBS = "Obs";

    public static List<PortableTimeSeries> parse(InputStreamReader inputStreamReader, DataFlowStructure dataFlowStructure, String string, boolean bl) throws XMLStreamException, UnsupportedEncodingException, SdmxException {
        logger.entering(sourceClass, "parse");
        ArrayList<PortableTimeSeries> arrayList = new ArrayList<PortableTimeSeries>();
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        BufferedReader bufferedReader = GenericDataParser.skipBOM(inputStreamReader);
        XMLEventReader xMLEventReader = xMLInputFactory.createXMLEventReader(bufferedReader);
        PortableTimeSeries portableTimeSeries = null;
        Hashtable<String, String> hashtable = null;
        Hashtable<String, String> hashtable2 = null;
        Hashtable<String, String> hashtable3 = null;
        while (xMLEventReader.hasNext()) {
            Object object;
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            logger.finest(xMLEvent2.toString());
            if (xMLEvent2.isStartElement()) {
                String string2;
                Attribute attribute;
                Hashtable<String, String> hashtable4;
                Object object2;
                Object object3;
                xMLEvent = xMLEvent2.asStartElement();
                if (xMLEvent.getName().getLocalPart() == DATASET) {
                    logger.finer("Got new dataset");
                    object = xMLEvent.getAttributes();
                    while (object.hasNext()) {
                        object3 = object.next();
                        object2 = object3.getName().getLocalPart().toString();
                        hashtable4 = object3.getValue();
                        if (((String)object2).equalsIgnoreCase(ACTION)) {
                            logger.finer("action: " + (String)((Object)hashtable4));
                            hashtable = hashtable4;
                            continue;
                        }
                        if (((String)object2).equalsIgnoreCase(VALID_FROM)) {
                            logger.finer("VALID_FROM: " + hashtable4);
                            hashtable2 = hashtable4;
                            continue;
                        }
                        if (!((String)object2).equalsIgnoreCase(VALID_TO)) continue;
                        logger.finer("VALID_TO: " + hashtable4);
                        hashtable3 = hashtable4;
                    }
                }
                if (xMLEvent.getName().getLocalPart() == MESSAGE) {
                    object = null;
                    object3 = null;
                    object2 = new LocalizedText(Configuration.getLang());
                    hashtable4 = xMLEvent.getAttributes();
                    while (hashtable4.hasNext()) {
                        attribute = (Attribute)hashtable4.next();
                        string2 = attribute.getName().toString();
                        String string3 = attribute.getValue();
                        if (string2.equalsIgnoreCase(CODE)) {
                            object = string3;
                            continue;
                        }
                        if (!string2.equalsIgnoreCase(SEVERITY)) continue;
                        object3 = string3;
                    }
                    xMLEventReader.nextEvent();
                    ((LocalizedText)object2).setText((StartElement)xMLEvent, xMLEventReader);
                    throw new SdmxException("SDMX Error received. Code: " + object + "; Severity: " + (String)object3 + ". Message: " + ((LocalizedText)object2).getText());
                }
                if (xMLEvent.getName().getLocalPart() == SERIES) {
                    logger.finer("Got new time series");
                    portableTimeSeries = new PortableTimeSeries();
                    portableTimeSeries.setDataflow(string);
                    object = xMLEvent.getAttributes();
                    CompactDataParser.setMetadata(portableTimeSeries, dataFlowStructure, object, hashtable, hashtable2, hashtable3);
                }
                if (xMLEvent.getName().getLocalPart().equals(OBS) && bl) {
                    xMLEvent2 = xMLEventReader.nextEvent();
                    logger.finest(xMLEvent2.toString());
                    object = xMLEvent.getAttributes();
                    object3 = null;
                    object2 = null;
                    hashtable4 = new Hashtable<String, String>();
                    while (object.hasNext()) {
                        attribute = (Attribute)object.next();
                        string2 = attribute.getName().toString();
                        if (string2.equals(dataFlowStructure.getTimeDimension())) {
                            object3 = attribute.getValue();
                            continue;
                        }
                        if (string2.equals(dataFlowStructure.getMeasure())) {
                            object2 = attribute.getValue();
                            continue;
                        }
                        hashtable4.put(string2, attribute.getValue());
                    }
                    if (object3 != null && !((String)object3).isEmpty() && object2 != null && !((String)object2).isEmpty()) {
                        portableTimeSeries.addObservation(new Double((String)object2), (String)object3, hashtable4);
                        continue;
                    }
                    throw new RuntimeException("Error during CompactData Parsing. Invalid Observation Time: " + (String)object3 + " or value: " + (String)object2);
                }
            }
            if (!xMLEvent2.isEndElement() || (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart() != SERIES) continue;
            logger.finer("Adding time series " + portableTimeSeries);
            object = portableTimeSeries.getTimeSlots();
            int n = object.size();
            if (n > 1 && ((String)object.get(n - 1)).compareToIgnoreCase((String)object.get(0)) < 0) {
                portableTimeSeries.reverse();
            }
            arrayList.add(portableTimeSeries);
        }
        logger.exiting(sourceClass, "parse");
        return arrayList;
    }

    private static void setMetadata(PortableTimeSeries portableTimeSeries, DataFlowStructure dataFlowStructure, Iterator<Attribute> iterator, String string, String string2, String string3) {
        logger.entering(sourceClass, "setMetadata");
        if (string != null) {
            portableTimeSeries.addAttribute("action=" + string);
        }
        if (string2 != null) {
            portableTimeSeries.addAttribute("validFromDate=" + string2);
        }
        if (string3 != null) {
            portableTimeSeries.addAttribute("validToDate=" + string3);
        }
        String[] stringArray = new String[dataFlowStructure.getDimensions().size()];
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            String string4 = attribute.getName().toString();
            String string5 = attribute.getValue();
            if (dataFlowStructure.isDimension(string4)) {
                stringArray[dataFlowStructure.getDimensionPosition((String)string4) - 1] = string4 + "=" + string5;
                if (string4.equalsIgnoreCase("FREQ") || string4.equalsIgnoreCase("FREQUENCY")) {
                    portableTimeSeries.setFrequency(string5);
                }
            } else {
                portableTimeSeries.addAttribute(string4 + "=" + string5);
            }
            portableTimeSeries.setDimensions(Arrays.asList(stringArray));
        }
        logger.exiting(sourceClass, "setMetadata");
    }
}

