/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.RegressionUtilities;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class FixedVariable {
    private final ITsVariable variable;
    private final ComponentType type;
    private final double[] coefficients;

    public FixedVariable(ITsVariable var, double[] coeff) {
        this.variable = var;
        this.type = ComponentType.Undefined;
        this.coefficients = coeff;
    }

    public FixedVariable(ITsVariable var, ComponentType cmp, double[] coeff) {
        this.variable = var;
        this.type = cmp;
        this.coefficients = coeff;
    }

    public ITsVariable getVariable() {
        return this.variable;
    }

    public ITsVariable getRootVariable() {
        return TsVariableList.getRoot(this.variable);
    }

    public <T extends ITsVariable> boolean isCompatible(Class<T> tclass) {
        return tclass.isAssignableFrom(TsVariableList.getRoot(this.variable).getClass());
    }

    private static DataBlock internalRegressionEffect(Stream<FixedVariable> regs, TsDomain domain, Predicate<FixedVariable> pred) {
        DataBlock z = new DataBlock(domain.getLength());
        regs.filter(reg -> pred.test((FixedVariable)reg)).forEach(reg -> {
            Matrix m = RegressionUtilities.matrix(reg.getVariable(), domain);
            for (int i = 0; i < reg.coefficients.length; ++i) {
                z.addAY(reg.coefficients[i], m.column(i));
            }
        });
        return z;
    }

    public static DataBlock regressionEffect(Stream<FixedVariable> regs, TsDomain domain, Predicate<ITsVariable> pred) {
        DataBlock z = new DataBlock(domain.getLength());
        regs.filter(reg -> pred.test(reg.variable)).forEach(reg -> {
            Matrix m = RegressionUtilities.matrix(reg.getVariable(), domain);
            for (int i = 0; i < reg.coefficients.length; ++i) {
                z.addAY(reg.coefficients[i], m.column(i));
            }
        });
        return z;
    }

    public static DataBlock regressionEffect(Stream<FixedVariable> regs, TsDomain domain, ComponentType type) {
        return FixedVariable.internalRegressionEffect(regs, domain, reg -> reg.getType() == type);
    }

    public static DataBlock regressionEffect(Stream<FixedVariable> regs, TsDomain domain) {
        return FixedVariable.internalRegressionEffect(regs, domain, reg -> true);
    }

    public static <T extends ITsVariable> DataBlock regressionEffect(Stream<FixedVariable> regs, TsDomain domain, Class<T> tclass) {
        return FixedVariable.internalRegressionEffect(regs, domain, reg -> tclass.isInstance(TsVariableList.getRoot(reg.variable)));
    }

    public ComponentType getType() {
        return this.type;
    }

    public double[] getCoefficients() {
        return this.coefficients;
    }
}

