/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.SubArrayOfBoolean;
import ec.tstoolkit.data.SubTable;
import ec.tstoolkit.design.PrimitiveReplacementOf;

@PrimitiveReplacementOf(generic=SubTable.class, primitive=boolean.class)
public class SubTableOfBoolean {
    boolean[] m_data;
    int m_start;
    int m_nrows;
    int m_ncols;
    int m_row_inc;
    int m_col_inc;

    public SubTableOfBoolean(boolean[] data, int nrows, int ncols) {
        this.m_data = data;
        this.m_nrows = nrows;
        this.m_ncols = ncols;
        this.m_row_inc = 1;
        this.m_col_inc = nrows;
    }

    public SubTableOfBoolean(boolean[] data, int start, int nrows, int ncols, int rowinc, int colinc) {
        this.m_data = data;
        this.m_start = start;
        this.m_nrows = nrows;
        this.m_ncols = ncols;
        this.m_row_inc = rowinc;
        this.m_col_inc = colinc;
    }

    public SubTableOfBoolean(SubTableOfBoolean m) {
        this.m_data = m.m_data;
        this.m_start = m.m_start;
        this.m_nrows = m.m_nrows;
        this.m_ncols = m.m_ncols;
        this.m_row_inc = m.m_row_inc;
        this.m_col_inc = m.m_col_inc;
    }

    public SubArrayOfBoolean column(int c) {
        int beg = this.m_start + c * this.m_col_inc;
        int end = beg + this.m_row_inc * this.m_nrows;
        return SubArrayOfBoolean.create(this.m_data, beg, end, this.m_row_inc);
    }

    public SubTableOfBoolean extract(int r0, int r1, int c0, int c1) {
        return new SubTableOfBoolean(this.m_data, this.m_start + r0 * this.m_row_inc + c0 * this.m_col_inc, r1 - r0, c1 - c0, this.m_row_inc, this.m_col_inc);
    }

    public SubTableOfBoolean extract(int r0, int c0, int nrows, int ncols, int rowinc, int colinc) {
        return new SubTableOfBoolean(this.m_data, this.m_start + r0 * this.m_row_inc + c0 * this.m_col_inc, nrows, ncols, this.m_row_inc * rowinc, this.m_col_inc * colinc);
    }

    public boolean get(int row, int col) {
        return this.m_data[this.m_start + row * this.m_row_inc + col * this.m_col_inc];
    }

    public int getColumnsCount() {
        return this.m_ncols;
    }

    public int getRowsCount() {
        return this.m_nrows;
    }

    public void move(int dr, int dc) {
        this.m_start += dr * this.m_row_inc + dc * this.m_col_inc;
    }

    public SubArrayOfBoolean row(int r) {
        int beg = this.m_start + r * this.m_row_inc;
        int end = beg + this.m_col_inc * this.m_ncols;
        return SubArrayOfBoolean.create(this.m_data, beg, end, this.m_col_inc);
    }

    public void set(int row, int col, boolean value) {
        this.m_data[this.m_start + row * this.m_row_inc + col * this.m_col_inc] = value;
    }

    public SubTableOfBoolean transpose() {
        return new SubTableOfBoolean(this.m_data, this.m_start, this.m_ncols, this.m_nrows, this.m_col_inc, this.m_row_inc);
    }
}

