/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.realfunctions.ProxyMinimizer;
import ec.tstoolkit.maths.realfunctions.levmar.LevenbergMarquardtMethod;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarmaSpecification;
import ec.tstoolkit.sarima.estimation.GlsSarimaMonitor;
import java.util.ArrayList;
import java.util.Arrays;

public class ArmaModule {
    static final double NO_BIC = 99999.0;
    private boolean balanced_;
    private boolean mixed_ = true;
    private RegArmaBic[] m_est;
    private boolean m_bforced = false;
    private int m_nmod = 5;
    private double eps_ = 1.0E-5;

    public double getEpsilon() {
        return this.eps_;
    }

    public void setEpsilon(double val) {
        this.eps_ = val;
    }

    public void setBalanced(boolean balanced) {
        this.balanced_ = balanced;
    }

    public boolean isBalanced() {
        return this.balanced_;
    }

    public void setMixed(boolean mixed) {
        this.mixed_ = mixed;
    }

    public boolean isMixed() {
        return this.mixed_;
    }

    public ArmaModule() {
    }

    public ArmaModule(int nmod) {
        this.m_nmod = nmod;
    }

    public void clear() {
        this.m_est = null;
    }

    public int getCount() {
        return this.m_est == null ? 0 : this.m_est.length;
    }

    public RegArmaBic[] getPreferedModels() {
        return this.m_est;
    }

    public boolean isMA1Forced() {
        return this.m_bforced;
    }

    private void merge(RegArmaBic[] mods) {
        if (this.m_est == null) {
            return;
        }
        int gmod = mods.length;
        int nmax = this.getCount();
        if (nmax > gmod) {
            nmax = gmod;
        }
        int icur = 0;
        block0: for (int i = 0; i < nmax && icur < gmod; ++i) {
            double bic = this.m_est[i].getBIC();
            for (int j = icur; j < gmod; ++j) {
                if (mods[j] == null) {
                    mods[j] = this.m_est[i];
                    icur = j + 1;
                    continue block0;
                }
                if (mods[j].getSpecification().equals((Object)this.m_est[i].getSpecification())) {
                    icur = j + 1;
                    continue block0;
                }
                if (!(mods[j].getBIC() > bic)) continue;
                for (int k = gmod - 1; k > j; --k) {
                    mods[k] = mods[k - 1];
                }
                mods[j] = this.m_est[i];
                icur = j + 1;
                continue block0;
            }
        }
    }

    public SarmaSpecification select(IReadDataBlock data, int d, int bd) {
        int idmax = this.m_nmod;
        while (this.m_est[idmax - 1].getBIC() == 99999.0) {
            --idmax;
        }
        SarmaSpecification spec = this.m_est[0].getSpecification();
        int nr1 = spec.getP() + spec.getQ();
        int ns1 = spec.getBP() + spec.getBQ();
        int nrr1 = Math.abs(spec.getP() + d - spec.getQ());
        int nss1 = Math.abs(spec.getBP() + bd - spec.getBQ());
        double bmax = this.m_est[idmax - 1].getBIC() - this.m_est[0].getBIC();
        bmax = bmax < 0.003 ? 0.0625 : (bmax < 0.03 ? 0.25 : 1.0);
        double vc11 = 0.01 * bmax;
        double vc2 = 0.0025 * bmax;
        double vc22 = 0.0075 * bmax;
        int idpref = 0;
        int icmod = 0;
        for (int i = 1; i < idmax; ++i) {
            SarmaSpecification cur = this.m_est[i].getSpecification();
            int nr2 = cur.getP() + cur.getQ();
            int ns2 = cur.getBP() + cur.getBQ();
            int nrr2 = Math.abs(cur.getP() + d - cur.getQ());
            int nss2 = Math.abs(cur.getBP() + bd - cur.getBQ());
            double dbic = this.m_est[i].getBIC() - this.m_est[idpref].getBIC();
            int chk = 0;
            if ((nrr2 < nrr1 || nss2 < nss1) && nr1 == nr2 && ns1 == ns2 && dbic <= vc11 && this.balanced_) {
                chk = 1;
            } else if (nrr2 < nrr1 && nr2 <= nr1 && ns2 == ns1 && dbic <= vc2 && cur.getP() > 0 && cur.getQ() > 0 && this.balanced_) {
                chk = 2;
            } else if ((nrr2 == 0 && nrr2 < nrr1 && d > 0 || nss2 == 0 && nss2 < nss1 && bd > 0) && nr1 == nr2 && ns1 == ns2 && dbic <= vc11 && this.balanced_) {
                chk = 3;
            } else if (nrr2 == 0 && nss2 == 0 && dbic < vc2 && this.balanced_) {
                chk = 4;
            } else if (nr2 > nr1 && nrr2 == 0 && ns2 == ns1 && dbic < vc2 && this.balanced_) {
                chk = 5;
            } else if (ns2 > ns1 && nss2 == 0 && nr2 == nr1 && dbic < vc2 && this.balanced_) {
                chk = 6;
            } else if (ns2 < ns1 && ns2 > 0 && nr2 == nr1 && nss2 == 0 && dbic < vc2 && this.balanced_) {
                chk = 7;
            } else if (i == 1 && nr1 == 0 && nr2 == 1 && ns2 == ns1 && dbic < vc2) {
                chk = 8;
            } else if (nr2 < nr1 && nr2 > 0 && ns2 == ns1 && dbic < vc2) {
                chk = 9;
            } else if (ns2 < ns1 && ns2 > 0 && nr2 == nr1 && dbic < vc2) {
                chk = 10;
            } else if (cur.getP() < spec.getP() && cur.getQ() == spec.getQ() && nr2 > 0 && ns2 == ns1 && dbic < vc22) {
                chk = 11;
            }
            if (chk <= 0) continue;
            ++icmod;
            double dc = this.m_est[i].getBIC() - this.m_est[0].getBIC();
            vc11 -= dc;
            vc2 -= dc;
            vc22 -= dc;
            nr1 = nr2;
            ns1 = ns2;
            nrr1 = nrr2;
            nss1 = nss2;
            idpref = i;
            spec = cur.clone();
        }
        if (spec.getParametersCount() == 0 && idpref < this.m_nmod - 1) {
            return this.m_est[idpref + 1].getSpecification().clone();
        }
        return this.m_est[idpref].getSpecification().clone();
    }

    public int sort(DataBlock data, SarmaSpecification[] specs) {
        int i;
        this.m_est = new RegArmaBic[specs.length];
        for (i = 0; i < specs.length; ++i) {
            this.m_est[i] = new RegArmaBic(data, specs[i], this.eps_);
        }
        Arrays.sort(this.m_est);
        for (i = this.m_est.length; i > 0; --i) {
            if (this.m_est[i - 1].getBIC() == 99999.0) continue;
            return i;
        }
        return 0;
    }

    public SarmaSpecification select(DataBlock data, int freq, int rmax, int smax, int d, int bd) {
        this.clear();
        SarmaSpecification spec = new SarmaSpecification();
        SarmaSpecification cur = new SarmaSpecification();
        this.m_est = new RegArmaBic[this.m_nmod];
        spec.setFrequency(freq);
        if (freq == 2) {
            spec.setP(1);
        } else {
            spec.setP(3);
        }
        spec.setQ(0);
        int nmax = 0;
        ArrayList<SarmaSpecification> lspecs0 = new ArrayList<SarmaSpecification>();
        if (freq != 1) {
            boolean i = false;
            for (int bp = 0; bp <= smax; ++bp) {
                for (int bq = 0; bq <= smax; ++bq) {
                    if (!this.mixed_ && bp != 0 && bq != 0) continue;
                    spec.setBP(bp);
                    spec.setBQ(bq);
                    lspecs0.add(spec.clone());
                }
            }
            ArmaModule step0 = new ArmaModule();
            SarmaSpecification[] specs0 = lspecs0.toArray(new SarmaSpecification[lspecs0.size()]);
            nmax = step0.sort(data, specs0);
            if (0 == nmax) {
                return null;
            }
            cur = step0.m_est[0].getSpecification().clone();
        } else {
            cur = spec.clone();
        }
        ArrayList<SarmaSpecification> lspecs1 = new ArrayList<SarmaSpecification>();
        for (int p = 0; p <= rmax; ++p) {
            for (int q = 0; q <= rmax; ++q) {
                if (!this.mixed_ && p != 0 && q != 0) continue;
                cur.setP(p);
                cur.setQ(q);
                lspecs1.add(cur.clone());
            }
        }
        ArmaModule step1 = new ArmaModule();
        SarmaSpecification[] specs1 = lspecs1.toArray(new SarmaSpecification[lspecs1.size()]);
        nmax = step1.sort(data, specs1);
        if (0 == nmax) {
            return null;
        }
        ArmaModule step2 = null;
        cur = step1.m_est[0].getSpecification().clone();
        step1.merge(this.m_est);
        int spmax = smax;
        int sqmax = smax;
        if (bd == 1) {
            spmax = 0;
        }
        if (freq != 1) {
            ArrayList<SarmaSpecification> lspecs2 = new ArrayList<SarmaSpecification>();
            boolean i = false;
            for (int bp = 0; bp <= spmax; ++bp) {
                for (int bq = 0; bq <= sqmax; ++bq) {
                    if (!this.mixed_ && bp != 0 && bq != 0) continue;
                    cur.setBP(bp);
                    cur.setBQ(bq);
                    lspecs2.add(cur.clone());
                }
            }
            step2 = new ArmaModule();
            SarmaSpecification[] specs2 = lspecs2.toArray(new SarmaSpecification[lspecs2.size()]);
            if (0 == step2.sort(data, specs2)) {
                return null;
            }
            step2.merge(this.m_est);
        } else {
            step2 = step1;
        }
        if (freq == 1) {
            if (this.m_est[0].getSpecification().getParametersCount() == 0) {
                return this.m_est[1].getSpecification().clone();
            }
            return this.m_est[0].getSpecification().clone();
        }
        return this.select(data, d, bd);
    }

    public static class RegArmaBic
    implements Comparable<RegArmaBic> {
        private final double m_bic;
        private final SarmaSpecification m_spec;

        public RegArmaBic(DataBlock data, SarmaSpecification spec, double eps) {
            GlsSarimaMonitor monitor = new GlsSarimaMonitor();
            monitor.setMinimizer(new ProxyMinimizer(new LevenbergMarquardtMethod()));
            monitor.setPrecision(eps);
            monitor.useLogLikelihood(false);
            this.m_spec = spec.clone();
            RegArimaModel<SarimaModel> model = new RegArimaModel<SarimaModel>(new SarimaModel(spec), data);
            RegArimaEstimation<SarimaModel> est = monitor.process(model);
            this.m_bic = est != null && monitor.hasConverged() ? est.statistics((int)spec.getParametersCount(), (double)0.0).BIC2 : 99999.0;
        }

        @Override
        public int compareTo(RegArmaBic o) {
            return Double.compare(this.m_bic, o.m_bic);
        }

        public double getBIC() {
            return this.m_bic;
        }

        public SarmaSpecification getSpecification() {
            return this.m_spec;
        }
    }
}

