/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.RegStatus;
import ec.tstoolkit.modelling.Variable;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.IRegressionTest;
import ec.tstoolkit.modelling.arima.JointRegressionTest;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.SeparateRegressionTest;
import ec.tstoolkit.modelling.arima.tramo.AbstractTramoModule;
import ec.tstoolkit.sarima.estimation.GlsSarimaMonitor;
import ec.tstoolkit.timeseries.regression.ILengthOfPeriodVariable;
import ec.tstoolkit.timeseries.regression.IMovingHolidayVariable;
import ec.tstoolkit.timeseries.regression.ITradingDaysVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.IUserTsVariable;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.regression.TsVariableSelection;
import java.util.List;

public class RegressionVariablesTest
extends AbstractTramoModule
implements IPreprocessingModule {
    public static final double CVAL = 1.96;
    public static final double T0 = 2.0;
    public static final double T1 = 2.6;
    public static final double T2 = 2.2;
    private IRegressionTest tdTest_;
    private IRegressionTest wdTest_;
    private IRegressionTest lpTest_;
    private IRegressionTest mhTest_;
    private IRegressionTest meanTest_;

    public RegressionVariablesTest(boolean join) {
        this.tdTest_ = join ? new JointRegressionTest(0.05) : new SeparateRegressionTest(2.0, 2.6);
        this.wdTest_ = new SeparateRegressionTest(2.2);
        this.lpTest_ = new SeparateRegressionTest(2.0);
        this.mhTest_ = new SeparateRegressionTest(1.96);
        this.meanTest_ = new SeparateRegressionTest(1.96);
    }

    private void addInfo(ModelDescription desc, InformationSet information) {
        InformationSet subset = information.subSet("calendar");
        subset.set("count", Integer.valueOf(Variable.usedVariablesCount(desc.getCalendars())));
        InformationSet esubset = information.subSet("easter");
        esubset.set("easter", Integer.valueOf(Variable.usedVariablesCount(desc.getMovingHolidays())));
    }

    private ModelDescription createTestModel(ModellingContext context) {
        ModelDescription model = context.description.clone();
        model.setAirline(context.hasseas);
        model.setMean(true);
        boolean hastd = model.variables().filter(var -> var.isCalendar()).findAny().isPresent();
        boolean hasmh = model.variables().filter(var -> var.isMovingHoliday()).findAny().isPresent();
        boolean hasuser = model.variables().filter(var -> var.isUser()).findAny().isPresent();
        if (hastd || hasmh || hasuser || context.automodelling) {
            return model;
        }
        return null;
    }

    @Override
    public ProcessingResult process(ModellingContext context) {
        Variable search;
        int i;
        ModelDescription tmpModel = this.createTestModel(context);
        if (tmpModel == null) {
            return ProcessingResult.Unprocessed;
        }
        boolean changed = false;
        ModelEstimation regarima = new ModelEstimation(tmpModel.buildRegArima());
        int nhp = tmpModel.getArimaComponent().getFreeParametersCount();
        GlsSarimaMonitor monitor = this.getMonitor();
        monitor.setPrecision(1.0E-4);
        regarima.compute(monitor, nhp);
        ConcentratedLikelihood ll = regarima.getLikelihood();
        InformationSet tdsubset = context.information.subSet("calendar");
        InformationSet esubset = context.information.subSet("easter");
        TsVariableList x = context.description.buildRegressionVariables();
        TsVariableSelection<ITsVariable> sel = x.selectCompatible(ITradingDaysVariable.class);
        TsVariableSelection.Item<ITsVariable>[] items = sel.elements();
        boolean usetd = false;
        int start = tmpModel.getRegressionVariablesStartingPosition();
        for (i = 0; i < items.length; ++i) {
            IRegressionTest test;
            search = context.description.searchVariable((ITsVariable)items[i].variable);
            if (!search.status.needTesting()) continue;
            IRegressionTest iRegressionTest = test = items[i].variable.getDim() == 1 ? this.wdTest_ : this.tdTest_;
            if (test.accept(ll, nhp, start + items[i].position, items[i].variable.getDim(), tdsubset)) {
                search.status = RegStatus.Accepted;
                usetd = true;
                continue;
            }
            search.status = RegStatus.Rejected;
            changed = true;
        }
        sel = x.selectCompatible(ILengthOfPeriodVariable.class);
        items = sel.elements();
        for (i = 0; i < items.length; ++i) {
            search = context.description.searchVariable((ITsVariable)items[i].variable);
            if (!search.status.needTesting()) continue;
            if (usetd && this.lpTest_.accept(ll, nhp, start + items[i].position, items[i].variable.getDim(), tdsubset)) {
                search.status = RegStatus.Accepted;
                continue;
            }
            search.status = RegStatus.Rejected;
            changed = true;
        }
        sel = x.selectCompatible(IMovingHolidayVariable.class);
        items = sel.elements();
        for (i = 0; i < items.length; ++i) {
            search = context.description.searchVariable((ITsVariable)items[i].variable);
            if (!search.status.needTesting()) continue;
            if (this.mhTest_.accept(ll, nhp, start + items[i].position, items[i].variable.getDim(), esubset)) {
                search.status = RegStatus.Accepted;
                continue;
            }
            search.status = RegStatus.Rejected;
            changed = true;
        }
        if (!this.testUsers(x, context.description.getCalendars(), start, ll, nhp)) {
            changed = true;
        }
        if (!this.testUsers(x, context.description.getMovingHolidays(), start, ll, nhp)) {
            changed = true;
        }
        if (!this.testUsers(x, context.description.getUserVariables(), start, ll, nhp)) {
            changed = true;
        }
        if (context.automodelling && tmpModel.isEstimatedMean() && !this.meanTest_.accept(ll, nhp, 0, 1, esubset)) {
            context.description.setMean(false);
            changed = true;
        }
        this.addInfo(context.description, context.information);
        return changed ? ProcessingResult.Changed : ProcessingResult.Unchanged;
    }

    private boolean testUsers(TsVariableList x, List<Variable> vars, int start, ConcentratedLikelihood ll, int nhp) {
        TsVariableSelection<ITsVariable> sel = x.select(var -> var instanceof IUserTsVariable && Variable.search(vars, var) != null);
        if (sel.isEmpty()) {
            return true;
        }
        TsVariableSelection.Item<ITsVariable>[] items = sel.elements();
        boolean changed = false;
        for (int i = 0; i < items.length; ++i) {
            IRegressionTest test;
            Variable search = Variable.search(vars, items[i].variable);
            if (!search.status.needTesting()) continue;
            IRegressionTest iRegressionTest = test = items[i].variable.getDim() == 1 ? this.wdTest_ : this.tdTest_;
            if (test.accept(ll, nhp, start + items[i].position, items[i].variable.getDim(), null)) {
                search.status = RegStatus.Accepted;
                continue;
            }
            search.status = RegStatus.Rejected;
            changed = true;
        }
        return changed;
    }
}

