/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.estimation;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.IArmaFilter;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.matrices.LowerTriangularMatrix;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.RationalFunction;

public class LjungBoxFilter
implements IArmaFilter {
    private int m_n;
    private int m_p;
    private int m_q;
    private Polynomial m_ar;
    private Polynomial m_ma;
    private double[] m_u;
    private Matrix m_G;
    private Matrix m_X;
    private Matrix m_V1;
    private Matrix m_L;
    private double m_s;
    private double m_t;

    @Override
    public LjungBoxFilter exemplar() {
        return new LjungBoxFilter();
    }

    private void ar(double[] a) {
        if (this.m_p > 0) {
            int j;
            double s;
            int i = a.length - 1;
            while (i >= this.m_p) {
                s = 0.0;
                for (j = 1; j <= this.m_p; ++j) {
                    s += this.m_ar.get(j) * a[i - j];
                }
                int n = i--;
                a[n] = a[n] + s;
            }
            i = this.m_p - 1;
            while (i > 0) {
                s = 0.0;
                for (j = 1; j <= i; ++j) {
                    s += this.m_ar.get(j) * a[i - j];
                }
                int n = i--;
                a[n] = a[n] + s;
            }
        }
    }

    private double[] calca0(IReadDataBlock w) {
        double[] a0 = new double[w.getLength()];
        w.copyTo(a0, 0);
        this.ar(a0);
        this.rma(a0);
        return a0;
    }

    private double[] calcg(double[] a0) {
        double[] g = (double[])a0.clone();
        if (this.m_q > 0) {
            int i = this.m_n - 2;
            while (i >= 0) {
                double s = 0.0;
                int j = 1;
                for (int k = i + 1; j <= this.m_q && k < this.m_n; ++j, ++k) {
                    s += this.m_ma.get(j) * g[k];
                }
                int n = i--;
                g[n] = g[n] - s;
            }
        }
        return g;
    }

    private void calcg(int m) {
        RationalFunction rf = new RationalFunction(Polynomial.ONE, this.m_ma);
        double[] pi = rf.coefficients(this.m_n);
        Matrix gg = new Matrix(m, m);
        for (int i = 0; i < m; ++i) {
            double s = 0.0;
            for (int j = i; j < this.m_n; ++j) {
                s += pi[j] * pi[j - i];
            }
            gg.set(i, 0, s);
        }
        for (int c = 1; c < m; ++c) {
            DataBlock col = gg.column(c);
            DataBlock prevcol = gg.column(c - 1);
            for (int r = c; r < m; ++r) {
                col.set(r, prevcol.get(r - 1) - pi[this.m_n - r] * pi[this.m_n - c]);
            }
        }
        SymmetricMatrix.fromLower(gg);
        this.m_G = gg;
    }

    private double[] calch(double[] g) {
        int j;
        int i;
        double[] h = new double[this.m_p + this.m_q];
        for (i = 0; i < this.m_p; ++i) {
            for (j = 0; j <= i; ++j) {
                int n = i;
                h[n] = h[n] - this.m_ar.get(this.m_p - i + j) * g[j];
            }
        }
        for (i = 0; i < this.m_q; ++i) {
            for (j = 0; j <= i; ++j) {
                int n = i + this.m_p;
                h[n] = h[n] + this.m_ma.get(this.m_q - i + j) * g[j];
            }
        }
        return h;
    }

    private void calcv(double[] v) {
        int j;
        int i;
        for (i = 0; i < this.m_p; ++i) {
            for (j = i; j < this.m_p; ++j) {
                int n = i;
                v[n] = v[n] - this.m_ar.get(this.m_p + i - j) * this.m_u[j];
            }
        }
        for (i = 0; i < this.m_q; ++i) {
            for (j = i; j < this.m_q; ++j) {
                int n = i;
                v[n] = v[n] + this.m_ma.get(this.m_q + i - j) * this.m_u[this.m_p + j];
            }
        }
        this.rma(v);
    }

    @Override
    public void filter(IReadDataBlock w, DataBlock wl) {
        if (this.m_G == null) {
            int n = wl.getLength();
            for (int i = 0; i < n; ++i) {
                wl.set(i, w.get(i));
            }
        } else {
            double[] a0 = this.calca0(w);
            double[] g = this.calcg(a0);
            this.m_u = this.calch(g);
            LowerTriangularMatrix.rsolve(this.m_X, this.m_u);
            LowerTriangularMatrix.lsolve(this.m_X, this.m_u);
            double[] v = new double[w.getLength()];
            this.calcv(v);
            for (int i = 0; i < a0.length; ++i) {
                int n = i;
                a0[n] = a0[n] - v[i];
            }
            wl.drop(this.m_u.length, 0).copyFrom(a0, 0);
            DataBlock wl0 = wl.range(0, this.m_u.length);
            wl0.copyFrom(this.m_u, 0);
            LowerTriangularMatrix.rsolve(this.m_L, wl0);
        }
    }

    @Override
    public double getLogDeterminant() {
        return this.m_s + this.m_t;
    }

    @Override
    public int initialize(IArimaModel arima, int n) {
        this.clear();
        this.m_ar = arima.getAR().getPolynomial().adjustDegree();
        this.m_ma = arima.getMA().getPolynomial().adjustDegree();
        this.m_n = n;
        this.m_p = this.m_ar.getDegree();
        this.m_q = this.m_ma.getDegree();
        int m = Math.max(this.m_p, this.m_q);
        if (m > 0) {
            int i;
            SubMatrix W;
            this.m_L = new Matrix(this.m_p + this.m_q, this.m_p + this.m_q);
            this.m_L.diagonal().set(1.0);
            this.m_V1 = new Matrix(m, this.m_p + this.m_q);
            if (this.m_p > 0) {
                double[] cov = arima.getAutoCovarianceFunction().values(this.m_p);
                W = this.m_L.subMatrix(0, this.m_p, 0, this.m_p);
                W.diagonal().set(cov[0]);
                for (int i2 = 1; i2 < this.m_p; ++i2) {
                    W.subDiagonal(i2).set(cov[i2]);
                }
                SubMatrix P = this.m_V1.subMatrix(0, this.m_p, 0, this.m_p);
                P.diagonal().set(-this.m_ar.get(this.m_p));
                for (i = 1; i < this.m_p; ++i) {
                    P.subDiagonal(i).set(-this.m_ar.get(this.m_p - i));
                }
            }
            if (this.m_q > 0) {
                SubMatrix Q = this.m_V1.subMatrix(0, this.m_q, this.m_p, this.m_p + this.m_q);
                Q.diagonal().set(this.m_ma.get(this.m_q));
                for (int i3 = 1; i3 < this.m_q; ++i3) {
                    Q.subDiagonal(i3).set(this.m_ma.get(this.m_q - i3));
                }
            }
            if (this.m_q > 0 && this.m_p > 0) {
                double[] psi = new RationalFunction(this.m_ma, this.m_ar).coefficients(this.m_q);
                W = this.m_L.subMatrix(0, this.m_p, this.m_p, this.m_p + this.m_q);
                int imin = this.m_q - this.m_p;
                for (i = 0; i < this.m_q; ++i) {
                    W.subDiagonal(imin - i).set(psi[i]);
                }
            }
            SymmetricMatrix.fromUpper(this.m_L);
            this.calcg(m);
            this.m_X = SymmetricMatrix.quadraticForm(this.m_G, this.m_V1);
            SymmetricMatrix.lcholesky(this.m_L);
            this.m_s = 2.0 * this.m_L.diagonal().sumLog().value;
            Matrix I = new Matrix(this.m_p + this.m_q, this.m_p + this.m_q);
            I.diagonal().set(1.0);
            DataBlockIterator cols = I.columns();
            DataBlock col = cols.getData();
            do {
                LowerTriangularMatrix.rsolve(this.m_L, col);
            } while (cols.next());
            cols.begin();
            do {
                LowerTriangularMatrix.lsolve(this.m_L, col);
            } while (cols.next());
            this.m_X.add(I);
            SymmetricMatrix.lcholesky(this.m_X);
            this.m_t = 2.0 * this.m_X.diagonal().sumLog().value;
        }
        return n + this.m_p + this.m_q;
    }

    void rma(double[] a) {
        if (this.m_q > 0) {
            int j;
            double s;
            int i = 1;
            while (i < this.m_q) {
                s = 0.0;
                for (j = 1; j <= i; ++j) {
                    s += this.m_ma.get(j) * a[i - j];
                }
                int n = i++;
                a[n] = a[n] - s;
            }
            i = this.m_q;
            while (i < a.length) {
                s = 0.0;
                for (j = 1; j <= this.m_q; ++j) {
                    s += this.m_ma.get(j) * a[i - j];
                }
                int n = i++;
                a[n] = a[n] - s;
            }
        }
    }

    private void clear() {
        this.m_G = null;
        this.m_X = null;
        this.m_V1 = null;
        this.m_L = null;
        this.m_s = 0.0;
        this.m_t = 0.0;
    }
}

