/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.eco;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.eco.EcoException;
import ec.tstoolkit.maths.matrices.Matrix;
import java.util.ArrayList;

public class RegModel
implements Cloneable {
    private DataBlock m_y;
    private boolean m_bmean = false;
    private ArrayList<DataBlock> m_x = new ArrayList();

    public static int[] cleanMissings(double[] y) {
        int nmiss = 0;
        int ny = y.length;
        for (int i = 0; i < ny; ++i) {
            if (!Double.isNaN(y[i])) continue;
            ++nmiss;
        }
        if (nmiss != 0) {
            int[] missings = new int[nmiss];
            int i0 = -1;
            int i1 = -1;
            int im = 0;
            for (int i = ny - 1; i >= 0; --i) {
                if (Double.isNaN(y[i])) {
                    if (i1 == -1) {
                        i1 = i + 1;
                    }
                    i0 = i - 1;
                    missings[im++] = i;
                    continue;
                }
                if (i0 == -1) continue;
                double v = i1 >= ny ? y[i0] : (y[i1] + y[i0]) / 2.0;
                for (int j = i0 + 1; j < i1; ++j) {
                    y[j] = v;
                }
                i1 = -1;
                i0 = -1;
            }
            if (i1 > 0) {
                if (i1 >= ny) {
                    throw new EcoException("Empty series", "Eco.cleanMissings");
                }
                for (int j = 0; j < i1; ++j) {
                    y[j] = y[i1];
                }
            }
            return missings;
        }
        return null;
    }

    public void addX(DataBlock x) {
        this.m_x.add(x);
    }

    public DataBlock calcRes(IReadDataBlock b) {
        if (b.getLength() != this.getVarsCount()) {
            return null;
        }
        DataBlock res = this.m_y.deepClone();
        int idx = 0;
        if (this.m_bmean) {
            double m = b.get(idx++);
            res.sub(m);
        }
        for (int i = 0; i < this.m_x.size(); ++i) {
            double c = -b.get(idx++);
            res.addAY(c, this.m_x.get(i));
        }
        return res;
    }

    public void clearX() {
        this.m_x.clear();
    }

    public RegModel clone() {
        try {
            RegModel reg = (RegModel)super.clone();
            reg.m_x = (ArrayList)this.m_x.clone();
            return reg;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    public int getObsCount() {
        return this.m_y.getLength();
    }

    public int getVarsCount() {
        int n = this.m_x.size();
        if (this.m_bmean) {
            ++n;
        }
        return n;
    }

    public int getXCount() {
        return this.m_x.size();
    }

    public DataBlock getY() {
        return this.m_y;
    }

    public void insertX(int pos, DataBlock x) {
        this.m_x.add(pos, x);
    }

    public boolean isMeanCorrection() {
        return this.m_bmean;
    }

    public void removeX(int idx) {
        this.m_x.remove(idx);
    }

    public void removeX(int i0, int n) {
        for (int i = 0; i < n; ++i) {
            this.m_x.remove(i0);
        }
    }

    public void setMeanCorrection(boolean value) {
        this.m_bmean = value;
    }

    public void setY(DataBlock value) {
        this.m_y = value;
    }

    public Matrix variables() {
        int nc = this.getVarsCount();
        int nr = this.getObsCount();
        if (nc == 0 || nr == 0) {
            return null;
        }
        Matrix m = new Matrix(nr, nc);
        DataBlockIterator cols = m.columns();
        DataBlock cur = cols.getData();
        if (this.m_bmean) {
            cur.set(1.0);
            cols.next();
        }
        for (int i = 0; i < this.m_x.size(); ++i) {
            cur.copy(this.m_x.get(i));
            cols.next();
        }
        return m;
    }

    public DataBlock X(int idx) {
        return this.m_x.get(idx);
    }
}

