/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.Blitter;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Rectangle;

public class ShortBlitter
implements Blitter {
    private ShortProcessor ip;
    private int width;
    private int height;
    private short[] pixels;

    public void setTransparentColor(Color color) {
    }

    public ShortBlitter(ShortProcessor shortProcessor) {
        this.ip = shortProcessor;
        this.width = shortProcessor.getWidth();
        this.height = shortProcessor.getHeight();
        this.pixels = (short[])shortProcessor.getPixels();
    }

    public void copyBits(ImageProcessor imageProcessor, int n, int n2, int n3) {
        int n4 = imageProcessor.getWidth();
        int n5 = imageProcessor.getHeight();
        Rectangle rectangle = new Rectangle(n4, n5);
        rectangle.setLocation(n, n2);
        Rectangle rectangle2 = new Rectangle(this.width, this.height);
        if (!rectangle.intersects(rectangle2)) {
            return;
        }
        short[] sArray = (short[])imageProcessor.getPixels();
        rectangle = rectangle.intersection(rectangle2);
        int n6 = n < 0 ? -n : 0;
        int n7 = n2 < 0 ? -n2 : 0;
        for (int i = rectangle.y; i < rectangle.y + rectangle.height; ++i) {
            int n8 = (i - n2) * n4 + (rectangle.x - n);
            int n9 = i * this.width + rectangle.x;
            switch (n3) {
                case 0: 
                case 1: 
                case 2: {
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        this.pixels[n9++] = sArray[n8++];
                    }
                    break;
                }
                case 14: {
                    int n11;
                    int n12;
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        n11 = (n12 = sArray[n8++] & 0xFFFF) == 0 ? this.pixels[n9] : n12;
                        this.pixels[n9++] = (short)n11;
                    }
                    break;
                }
                case 3: {
                    int n11;
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        if ((n11 = (sArray[n8++] & 0xFFFF) + (this.pixels[n9] & 0xFFFF)) < 0) {
                            n11 = 0;
                        }
                        if (n11 > 65535) {
                            n11 = 65535;
                        }
                        this.pixels[n9++] = (short)n11;
                    }
                    break;
                }
                case 7: {
                    int n11;
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        n11 = ((sArray[n8++] & 0xFFFF) + (this.pixels[n9] & 0xFFFF)) / 2;
                        this.pixels[n9++] = (short)n11;
                    }
                    break;
                }
                case 8: {
                    int n11;
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        if ((n11 = (this.pixels[n9] & 0xFFFF) - (sArray[n8++] & 0xFFFF)) < 0) {
                            n11 = -n11;
                        }
                        if (n11 > 65535) {
                            n11 = 65535;
                        }
                        this.pixels[n9++] = (short)n11;
                    }
                    break;
                }
                case 4: {
                    int n11;
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        if ((n11 = (this.pixels[n9] & 0xFFFF) - (sArray[n8++] & 0xFFFF)) < 0) {
                            n11 = 0;
                        }
                        if (n11 > 65535) {
                            n11 = 65535;
                        }
                        this.pixels[n9++] = (short)n11;
                    }
                    break;
                }
                case 5: {
                    int n11;
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        if ((n11 = (sArray[n8++] & 0xFFFF) * (this.pixels[n9] & 0xFFFF)) < 0) {
                            n11 = 0;
                        }
                        if (n11 > 65535) {
                            n11 = 65535;
                        }
                        this.pixels[n9++] = (short)n11;
                    }
                    break;
                }
                case 6: {
                    int n11;
                    int n12;
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        n11 = (n12 = sArray[n8++] & 0xFFFF) == 0 ? 65535 : (this.pixels[n9] & 0xFFFF) / n12;
                        this.pixels[n9++] = (short)n11;
                    }
                    break;
                }
                case 9: {
                    int n11;
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        n11 = sArray[n8++] & this.pixels[n9] & 0xFFFF;
                        this.pixels[n9++] = (short)n11;
                    }
                    break;
                }
                case 10: {
                    int n11;
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        n11 = sArray[n8++] | this.pixels[n9];
                        this.pixels[n9++] = (short)n11;
                    }
                    break;
                }
                case 11: {
                    int n11;
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        n11 = sArray[n8++] ^ this.pixels[n9];
                        this.pixels[n9++] = (short)n11;
                    }
                    break;
                }
                case 12: {
                    int n11;
                    int n12;
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        n11 = this.pixels[n9] & 0xFFFF;
                        if ((n12 = sArray[n8++] & 0xFFFF) < n11) {
                            n11 = n12;
                        }
                        this.pixels[n9++] = (short)n11;
                    }
                    break;
                }
                case 13: {
                    int n11;
                    int n12;
                    int n10 = rectangle.width;
                    while (--n10 >= 0) {
                        n11 = this.pixels[n9] & 0xFFFF;
                        if ((n12 = sArray[n8++] & 0xFFFF) > n11) {
                            n11 = n12;
                        }
                        this.pixels[n9++] = (short)n11;
                    }
                    break;
                }
            }
            if (i % 20 != 0) continue;
            imageProcessor.showProgress((double)(i - rectangle.y) / (double)rectangle.height);
        }
        imageProcessor.showProgress(1.0);
    }
}

