/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.WindowManager;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.frame.ContrastAdjuster;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import java.awt.Frame;

public class LutApplier
implements PlugInFilter {
    ImagePlus imp;
    int min;
    int max;
    boolean canceled;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        int n = 83;
        if (imagePlus != null && imagePlus.getType() == 4) {
            return n + 256;
        }
        return n;
    }

    public void run(ImageProcessor imageProcessor) {
        this.apply(this.imp, imageProcessor);
    }

    void apply(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        if (imageProcessor.getMinThreshold() != -808080.0) {
            imagePlus.unlock();
            IJ.runPlugIn("ij.plugin.Thresholder", "skip");
            return;
        }
        this.min = (int)imageProcessor.getMin();
        this.max = (int)imageProcessor.getMax();
        if (this.min == 0 && this.max == 255) {
            IJ.error("Apply LUT", "The display range must first be updated\nusing Image>Adjust>Brightness/Contrast\nor threshold levels defined using\nImage>Adjust>Threshold.");
            return;
        }
        if (imagePlus.getType() == 4) {
            if (imagePlus.getStackSize() > 1) {
                this.applyRGBStack(imagePlus);
            } else {
                imageProcessor.reset();
                Undo.setup(6, imagePlus);
                imageProcessor.setMinAndMax(this.min, this.max);
            }
            if (this.canceled) {
                imageProcessor.reset();
            }
            this.resetContrastAdjuster();
            return;
        }
        imageProcessor.resetMinAndMax();
        int[] nArray = new int[256];
        for (int i = 0; i < 256; ++i) {
            nArray[i] = i <= this.min ? 0 : (i >= this.max ? 255 : (int)((double)(i - this.min) / (double)(this.max - this.min) * 255.0));
        }
        if (imagePlus.getStackSize() > 1) {
            ImageStack imageStack = imagePlus.getStack();
            int n = IJ.setupDialog(imagePlus, 0);
            if (n == 4096) {
                imageProcessor.setMinAndMax(this.min, this.max);
                return;
            }
            if (n == 32) {
                new StackProcessor(imageStack, imageProcessor).applyTable(nArray);
                Undo.reset();
            } else {
                imageProcessor.applyTable(nArray);
            }
        } else {
            imageProcessor.applyTable(nArray);
        }
        this.resetContrastAdjuster();
    }

    void resetContrastAdjuster() {
        Frame frame = WindowManager.getFrame("B&C");
        if (frame == null) {
            frame = WindowManager.getFrame("W&L");
        }
        if (frame != null && frame instanceof ContrastAdjuster) {
            ((ContrastAdjuster)frame).updateAndDraw();
        }
    }

    void applyRGBStack(ImagePlus imagePlus) {
        int n = imagePlus.getCurrentSlice();
        int n2 = imagePlus.getStackSize();
        if (!IJ.showMessageWithCancel("Update Entire Stack?", "Apply brightness and contrast settings\nto all " + n2 + " slices in the stack?\n \n" + "NOTE: There is no Undo for this operation.")) {
            this.canceled = true;
            return;
        }
        for (int i = 1; i <= n2; ++i) {
            if (i == n) continue;
            imagePlus.setSlice(i);
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            imageProcessor.setMinAndMax(this.min, this.max);
            IJ.showProgress((double)i / (double)n2);
        }
        imagePlus.setSlice(n);
    }
}

