/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.io.SaveDialog;
import ij.plugin.Animator;
import ij.plugin.GifEncoder;
import ij.plugin.PlugIn;

public class GifWriter
implements PlugIn {
    static int transparentIndex = Prefs.getTransparentIndex();

    public void run(String string) {
        Object object;
        ImagePlus imagePlus = IJ.getImage();
        if (string.equals("")) {
            object = new SaveDialog("Save as Gif", imagePlus.getTitle(), ".gif");
            if (((SaveDialog)object).getFileName() == null) {
                return;
            }
            string = ((SaveDialog)object).getDirectory() + ((SaveDialog)object).getFileName();
        }
        object = imagePlus.getStack();
        ImagePlus imagePlus2 = new ImagePlus();
        int n = ((ImageStack)object).getSize();
        GifEncoder gifEncoder = new GifEncoder();
        double d = imagePlus.getCalibration().fps;
        if (d == 0.0) {
            d = Animator.getFrameRate();
        }
        if (d <= 0.2) {
            d = 0.2;
        }
        if (d > 60.0) {
            d = 60.0;
        }
        gifEncoder.setDelay((int)(1.0 / d * 1000.0));
        if (transparentIndex != -1) {
            gifEncoder.transparent = true;
            gifEncoder.transIndex = transparentIndex;
        }
        gifEncoder.start(string);
        for (int i = 1; i <= n; ++i) {
            IJ.showStatus("writing: " + i + "/" + n);
            IJ.showProgress((double)i / (double)n);
            imagePlus2.setProcessor(null, ((ImageStack)object).getProcessor(i));
            try {
                gifEncoder.addFrame(imagePlus2);
                continue;
            }
            catch (Exception exception) {
                IJ.showMessage("Save as Gif", "" + exception);
                return;
            }
        }
        gifEncoder.finish();
        IJ.showStatus("");
        IJ.showProgress(1.0);
    }
}

