% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsUpdateEEDataSets.R
\name{lsUpdateEEDataSets}
\alias{lsUpdateEEDataSets}
\title{Update EarthExplorer dataset names}
\usage{
lsUpdateEEDataSets(username, password, logout = TRUE, verbose = FALSE)
}
\arguments{
\item{username}{USGS's `EarthExplorer' username.}

\item{password}{USGS's `EarthExplorer' password.}

\item{logout}{logical argument. If \code{TRUE}, logges out from EarthExplorer
API}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the 
running steps and warnings.}
}
\value{
the dataset names in EarthExplorer API
}
\description{
The `EE.DataSets' option of 'RGISTools' contains all the dataset names
supported by EarthExplorer API. If these names changes, \code{\link{lsUpdateEEDataSets}}
updates these data.
}
\examples{
\dontrun{
setRGISToolsOpt("EE.DataSets",NULL)
getRGISToolsOpt("EE.DataSets")
datasetNames<-lsUpdateEEDataSets(username = "username",
                                 password = "password")

getRGISToolsOpt("EE.DataSets")
}
}
