% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varSAVI.R
\name{varSAVI}
\alias{varSAVI}
\title{Calculates soil-adjusted vegetation index (SAVI)}
\usage{
varSAVI(red, nir, L = 0.5, scfun = function(r) {     r })
}
\arguments{
\item{red}{a \code{raster} with the red band of the capture.}

\item{nir}{a \code{raster} with the NIR band of the capture.}

\item{L}{a constant to remove soil background effect. A value of 0.5 is
recommended in the literature.}

\item{scfun}{a function to re-scale the original pixel values into 
reflectance (0-1).}
}
\value{
A SAVI image in \code{raster} format.
}
\description{
\code{varSAVI} Calculate the soil-adjusted vegetation index (SAVI) from the
red and near-infrared (NIR) bands.
}
\details{
The soil adjusted vegetation index (SAVI) is an indicator engineered to remove 
the influence of the soil background effect \insertCite{huete1988soil}{RGISTools}.  
This function is used within \code{\link{ls7FolderToVar}}, 
\code{\link{ls8FolderToVar}}, \code{\link{modFolderToVar}} and
\code{\link{senFolderToVar}}.
}
\examples{
# path to the cropped and cutted MODIS images for the region of Navarre
img.dir <- system.file("ExNavarreVar", package = "RGISTools")
# list all the tif files
img.files <- list.files(img.dir, pattern="\\\\.tif$", recursive = TRUE, full.names = TRUE)
# print the MOD09 bands
getRGISToolsOpt("MOD09BANDS")

# select the red and NIR bands
red <- raster(img.files[1])
nir <- raster(img.files[2])
# calculate the SAVI image
savi <- varSAVI(red,nir,scfun=getRGISToolsOpt("MOD09SCL"))
# plot the image
spplot(savi,col.regions=rev(topo.colors(20)))
}
\references{
\insertRef{huete1988soil}{RGISTools}
}
