% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modExtractHDF.R
\name{modExtractHDF}
\alias{modExtractHDF}
\title{Convert an HDF file into a set of GTiff files}
\usage{
modExtractHDF(filesHDF, AppRoot, overwrite = FALSE, bFilter = NULL,
  rm.band = NULL, shp = NULL, verbose = FALSE, ...)
}
\arguments{
\item{filesHDF}{the full path where the HDF files are located.}

\item{AppRoot}{the directory where the extracted images are saved.}

\item{overwrite}{logical argument. If \code{TRUE}, overwrites the existing
images with the same name.}

\item{bFilter}{a vector containing the names of the bands to extract.}

\item{rm.band}{a vector containing the names of the bands excluded from the
extraction.}

\item{shp}{the path to shape file of the area of interest in the hard drive.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the 
running steps and warnings.}

\item{...}{arguments for nested functions.}
}
\description{
\code{modExtractHDF} converts the original format of MODIS images (hierarchical
data format or HDF) into GTiffs (one file for each layer).
}
\details{
HDF files cannot be directly loaded into `R', so they must be converted into
GTiffs. To acomplish this task, the function \code{modExtractHDF}
borrows the \code{gdalwarp} and \code{gdal_translate} functions from the 
`\code{gdalUtils}' package. Further details about these functions can be found
in the corresponding package manual. `GDAL' and `\code{gdalUtils}' must be 
properly installed to use \code{modExtractHDF}. GTiffs can be loaded in `R'
using the `\code{raster}' package.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre
data(ex.navarre)

src <- paste0(tempdir(),"/Path_for_downloading_folder")
print(src)
src.mod <- file.path(src, "Modis","MOD11A1")
src.mod.hdf <- file.path(src.mod, "hdf")
img.list <- modSearch(product = "MOD11A1",
                      startDate = as.Date("01-01-2011", "\%d-\%m-\%Y"),
                      endDate = as.Date("01-01-2011", "\%d-\%m-\%Y"),
                      collection = 6,
                      extent = ex.navarre,
                      AppRoot = src.mod.hdf)
                      
# download the images of the list
src.mod <- file.path(src, "Modis", "MOD11A1")
modDownSearch(searchres = img.list, 
              username = "username", 
              password = "password",
              AppRoot = src.mod.hdf)

src.tif<-file.path(src.mod,"tif")

# extract the first image
hdf.files <- list.files(src.mod.hdf, 
                        full.names = TRUE, 
                        pattern = "\\\\.hdf$")
first.hdf.file <- hdf.files[1]
modExtractHDF(filesHDF = first.hdf.file,
              AppRoot = src.tif)
}
}
