% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgcca_transform.R
\name{rgcca_transform}
\alias{rgcca_transform}
\title{Reduce dimensionality using RGCCA}
\usage{
rgcca_transform(rgcca_res, blocks_test = rgcca_res$call$blocks)
}
\arguments{
\item{rgcca_res}{A fitted RGCCA object (see  \code{\link[RGCCA]{rgcca}}).}

\item{blocks_test}{A list of blocks (data.frame or matrix) to be projected.}
}
\value{
A list of matrices containing the projections of the test blocks
using the block weight vectors of a fitted RGCCA object.
}
\description{
This function projects testing blocks using the block weight vectors of a
fitted RGCCA object.
}
\examples{
data("Russett")
blocks <- list(
  agriculture = Russett[, 1:3],
  industry = Russett[, 4:5],
  politic = Russett[, 6:11])

Xtrain <- lapply(blocks, function(x) x[1:32, ])
Xtest <- lapply(blocks, function(x) x[33:47, ])
fit_rgcca <- rgcca(Xtrain, ncomp = 2)
projection <- rgcca_transform(fit_rgcca, Xtest)
}
