% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom-mets.R
\name{list_custom_metrics}
\alias{list_custom_metrics}
\title{Custom Metrics}
\usage{
list_custom_metrics(account.id, webproperty.id, start.index = NULL,
  max.results = NULL, token)
}
\arguments{
\item{account.id}{character. Account ID for the custom metrics to retrieve.}

\item{webproperty.id}{character. Web property ID for the custom metrics to retrieve.}

\item{start.index}{integer. An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.}

\item{max.results}{integer. The maximum number of custom metrics to include in this response.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}
}
\value{
\item{kind}{Kind value for a custom metric. Set to "analytics#customMetric". It is a read-only field.}
\item{id}{Custom metric ID.}
\item{account.id}{Account ID.}
\item{webproperty.id}{Property ID.}
\item{name}{Name of the custom metric.}
\item{index}{Index of the custom metric.}
\item{scope}{Scope of the custom metric: HIT or PRODUCT.}
\item{active}{Boolean indicating whether the custom metric is active.}
\item{type}{Data type of custom metric.}
\item{min_value}{Min value of custom metric.}
\item{max_value}{Max value of custom metric.}
\item{created}{Time the custom metric was created.}
\item{updated}{Time the custom metric was last modified.}
}
\description{
Lists custom metrics to which the user has access.
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/customMetrics}{Management API - Custom Metrics Overview}
}
\seealso{
Other Management API: \code{\link{get_custom_dimension}},
  \code{\link{get_custom_metric}},
  \code{\link{get_experiment}}, \code{\link{get_filter}},
  \code{\link{get_goal}}, \code{\link{get_profile}},
  \code{\link{get_unsampled_report}},
  \code{\link{get_upload}}, \code{\link{get_webproperty}},
  \code{\link{list_accounts}},
  \code{\link{list_custom_data_sources}},
  \code{\link{list_custom_dimensions}},
  \code{\link{list_experiments}},
  \code{\link{list_filters}}, \code{\link{list_goals}},
  \code{\link{list_profiles}}, \code{\link{list_segments}},
  \code{\link{list_unsampled_reports}},
  \code{\link{list_uploads}},
  \code{\link{list_webproperties}}
}

