/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.generalstring;

import freak.core.control.Schedule;
import freak.core.event.EventListener;
import freak.core.event.RunEvent;
import freak.core.event.RunEventListener;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Genotype;
import freak.module.fitness.generalstring.SSSPUniformInstance;
import freak.module.searchspace.GeneralString;
import freak.module.searchspace.GeneralStringGenotype;

public class SSSPSingleObjective
extends AbstractStaticSingleObjectiveFitnessFunction
implements RunEventListener,
Configurable {
    private SSSPUniformInstance instance = null;
    private int maxWeight = 10;
    private boolean instanceCreated = false;

    public SSSPSingleObjective(Schedule schedule) {
        super(schedule);
        GeneralString sp = (GeneralString)this.getSchedule().getGenotypeSearchSpace();
        this.instance = new SSSPUniformInstance(sp.getDimension() + 1, schedule.getRandomElement(), 10);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        GeneralString sp = (GeneralString)this.getSchedule().getGenotypeSearchSpace();
        if (sp.getPropertyNumberOfChars() != sp.getDimension() + 1) {
            throw new UnsupportedEnvironmentException("The number of characters must equals the dimension+1.");
        }
    }

    protected double evaluate(Genotype genotype) {
        try {
            int[] gt = ((GeneralStringGenotype)genotype).getIntArray();
            double[] distances = this.instance.getMultiFitness(gt);
            double result = 0.0;
            int numNonPath = 0;
            int i = 0;
            while (i < distances.length) {
                if (distances[i] == Double.POSITIVE_INFINITY) {
                    ++numNonPath;
                } else {
                    result += distances[i];
                }
                ++i;
            }
            return -(result + (double)numNonPath * this.instance.getLargestMatrixEntry() * (double)(gt.length + 1));
        }
        catch (Exception e) {
            System.out.println(e.getStackTrace());
            throw new RuntimeException("Fehler mit den SSSP-Dimensionen.");
        }
    }

    public String getName() {
        return "Single Objective SSSP";
    }

    public String getDescription() {
        return "This fitness function represents the single source shortest path problem. Each entry in the distance matrix is choosen uniformly at random from the set {1,...,maxDistance}. The fitness of a search point x is the sum of the lengths of the paths, if x represents a tree. Otherwise, for all nodes not connected to the source s a penalty term is added.";
    }

    public Integer getPropertyMaxDistance() {
        return new Integer(this.maxWeight);
    }

    public void setPropertyMaxDistance(Integer i) {
        this.maxWeight = i;
        this.instance.setMaxDistance(this.maxWeight);
    }

    public double getOptimalFitnessValue() {
        if (!this.instanceCreated) {
            return 0.0;
        }
        double[] opt = this.instance.getOptimum();
        double result = 0.0;
        int i = 0;
        while (i < opt.length) {
            result += opt[i];
            ++i;
        }
        return -result;
    }

    public void runStarted(RunEvent evt) {
        this.instance.setRandomElement(this.getSchedule().getRandomElement());
        this.instance.nextInstance();
        this.instanceCreated = true;
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, RunEvent.class, this.schedule);
    }
}

