/*
 * Decompiled with CFR 0.152.
 */
package freak.rinterface.control;

import freak.Freak;
import freak.core.control.Actions;
import freak.core.control.Batch;
import freak.core.control.BatchList;
import freak.core.control.FreakFile;
import freak.core.control.Replay;
import freak.core.control.RunControl;
import freak.core.control.Schedule;
import freak.core.control.StateListener;
import freak.core.fitness.FitnessFunction;
import freak.core.graph.FreakGraphModel;
import freak.core.graph.Initialization;
import freak.core.modulesupport.AbstractBasicModule;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.observer.Observer;
import freak.core.observer.ObserverManager;
import freak.core.observer.ObserverViewMismatchException;
import freak.core.populationmanager.PopulationManager;
import freak.core.searchspace.SearchSpace;
import freak.core.stoppingcriterion.StoppingCriterion;
import freak.gui.graph.OperatorGraphFile;
import freak.gui.scheduleeditor.ScheduleDependencyChecker;
import freak.module.fitness.bitstring.OneMax;
import freak.module.fitness.booleanfunction.GenericPareto;
import freak.module.observer.ResultObserver;
import freak.module.operator.initialization.RandomInitialization;
import freak.module.populationmanager.DefaultPopulationManager;
import freak.module.postprocessor.booleanfunction.Count;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BooleanFunction;
import freak.module.stoppingcriterion.GenerationCount;
import freak.module.view.FileWriter;
import freak.rinterface.model.RReturns;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class LogRegInterface
implements StateListener {
    public static boolean launchedFromR = false;
    public static boolean scheduleWillBeSetByR = false;
    private static Schedule rSchedule;
    private RunControl runControl;
    private File loadFile;
    private File saveFile;
    private File[] tempFiles;
    private int nextTempFile;
    private long lastSave;
    private long saveInterval;
    private volatile boolean terminated = false;

    public LogRegInterface(File loadFile, File saveFile, File[] tempFiles, long saveInterval) {
        this.loadFile = loadFile;
        this.saveFile = saveFile;
        this.tempFiles = tempFiles;
        this.saveInterval = saveInterval;
    }

    public void run() throws FileNotFoundException, IOException, ClassNotFoundException {
        RReturns.clear();
        if (scheduleWillBeSetByR) {
            this.runControl = new RunControl(this);
            this.runControl.setNewSchedule(rSchedule);
            this.runControl.request(new Actions.StartAction());
        } else {
            this.runControl = new RunControl(this);
            Freak.debug("Trying to read " + this.loadFile, 2);
            FreakFile file = FreakFile.read(new FileInputStream(this.loadFile));
            this.runControl.fromFile(file);
            this.lastSave = System.currentTimeMillis();
            Freak.debug("Read successfull " + this.loadFile, 2);
            Freak.debug("Starting " + this.loadFile, 2);
            this.runControl.request(new Actions.StartAction());
        }
        while (launchedFromR && !this.terminated) {
        }
    }

    public Schedule testScheduleCopying(Schedule aSchedule) {
        Schedule schedule = new Schedule();
        ScheduleDependencyChecker scheduleDependencyChecker = new ScheduleDependencyChecker(null);
        scheduleDependencyChecker.setSchedule(schedule);
        try {
            schedule.setPhenotypeSearchSpace(aSchedule.getPhenotypeSearchSpace());
            schedule.setFitnessFunction(aSchedule.getFitnessFunction());
            GenerationCount generationCount = new GenerationCount(schedule);
            generationCount.setPropertyCount(new Integer(40));
            generationCount.testSchedule(schedule);
            generationCount.initialize();
            generationCount.createEvents();
            StoppingCriterion[] stoppingCriteria = new StoppingCriterion[]{generationCount};
            schedule.setStoppingCriteria(stoppingCriteria);
            schedule.setPopulationManager(aSchedule.getPopulationManager());
            schedule.setGraphModel(aSchedule.getFreakGraphModel());
            schedule.setInitialization(aSchedule.getInitialization());
        }
        catch (UnsupportedEnvironmentException e) {
            throw new RuntimeException("Something is wrong with the default Schedule.", e);
        }
        schedule.modulesEdited();
        return schedule;
    }

    public Schedule createSchedule() {
        AbstractBasicModule m;
        Schedule schedule = new Schedule();
        ScheduleDependencyChecker scheduleDependencyChecker = new ScheduleDependencyChecker(null);
        scheduleDependencyChecker.setSchedule(schedule);
        try {
            m = new BooleanFunction(schedule);
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            schedule.setPhenotypeSearchSpace((SearchSpace)((Object)m));
            m = new GenericPareto(schedule);
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            schedule.setFitnessFunction((FitnessFunction)((Object)m));
            GenerationCount generationCount = new GenerationCount(schedule);
            generationCount.setPropertyCount(new Integer(40));
            generationCount.testSchedule(schedule);
            generationCount.initialize();
            generationCount.createEvents();
            StoppingCriterion[] stoppingCriteria = new StoppingCriterion[]{generationCount};
            schedule.setStoppingCriteria(stoppingCriteria);
            m = new DefaultPopulationManager(schedule);
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            schedule.setPopulationManager((PopulationManager)((Object)m));
            File f = new File("./export/resource/freak/module/graph/booleanfunction/ZuFaulZumKlicken.fop");
            try {
                OperatorGraphFile ogFile = OperatorGraphFile.read(new FileInputStream(f));
                FreakGraphModel model = ogFile.generateGraph(schedule);
                schedule.setGraphModel(model);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            m = new RandomInitialization(schedule.getOperatorGraph());
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            ((Initialization)m).hideNameProperty();
            schedule.setInitialization((Initialization)m);
        }
        catch (UnsupportedEnvironmentException e) {
            throw new RuntimeException("Something is wrong with the default Schedule.", e);
        }
        ObserverManager om = schedule.getObserverManager();
        m = new ResultObserver(schedule);
        FileWriter output = new FileWriter(schedule);
        try {
            ((Observer)((Object)m)).addView(output);
        }
        catch (ObserverViewMismatchException e) {
            e.printStackTrace();
        }
        ((ResultObserver)m).setPostprocessor(-1);
        ((ResultObserver)m).setSelectPostprocessorFromGui(false);
        Count postprocessor = new Count(schedule);
        ((ResultObserver)m).setSelectedProcessor(postprocessor);
        m.initialize();
        m.createEvents();
        om.addObserver((Observer)((Object)m));
        Batch batch = schedule.createBatchFromCurrentConfigurations();
        batch.setRuns(1);
        BatchList batchList = schedule.getBatchList();
        batchList.clear();
        batchList.add(batch.copy(), true);
        schedule.modulesEdited();
        return schedule;
    }

    public Schedule testScheduleCreation() {
        Schedule schedule = new Schedule();
        ScheduleDependencyChecker scheduleDependencyChecker = new ScheduleDependencyChecker(null);
        scheduleDependencyChecker.setSchedule(schedule);
        try {
            AbstractBasicModule m = new BitString(schedule);
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            schedule.setPhenotypeSearchSpace((SearchSpace)((Object)m));
            m = new OneMax(schedule);
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            schedule.setFitnessFunction((FitnessFunction)((Object)m));
            GenerationCount generationCount = new GenerationCount(schedule);
            generationCount.setPropertyCount(new Integer(40));
            generationCount.testSchedule(schedule);
            generationCount.initialize();
            generationCount.createEvents();
            StoppingCriterion[] stoppingCriteria = new StoppingCriterion[]{generationCount};
            schedule.setStoppingCriteria(stoppingCriteria);
            m = new DefaultPopulationManager(schedule);
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            schedule.setPopulationManager((PopulationManager)((Object)m));
            File f = new File("./export/resource/freak/module/graph/common/(1+1)EA.fop");
            try {
                OperatorGraphFile ogFile = OperatorGraphFile.read(new FileInputStream(f));
                FreakGraphModel model = ogFile.generateGraph(schedule);
                schedule.setGraphModel(model);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            m = new RandomInitialization(schedule.getOperatorGraph());
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            ((Initialization)m).hideNameProperty();
            schedule.setInitialization((Initialization)m);
        }
        catch (UnsupportedEnvironmentException e) {
            throw new RuntimeException("Something is wrong with the default Schedule.", e);
        }
        scheduleDependencyChecker.createDefaultBatch();
        if (schedule.getBatchList().size() == 0) {
            scheduleDependencyChecker.createDefaultBatchList();
        }
        schedule.modulesEdited();
        return schedule;
    }

    public void testScheduleEditing(Schedule schedule) {
        try {
            GenerationCount generationCount = new GenerationCount(schedule);
            generationCount.setPropertyCount(new Integer(40));
            generationCount.testSchedule(schedule);
            generationCount.initialize();
            generationCount.createEvents();
            StoppingCriterion[] stoppingCriteria = new StoppingCriterion[]{generationCount};
            schedule.setStoppingCriteria(stoppingCriteria);
        }
        catch (UnsupportedEnvironmentException e) {
            throw new RuntimeException("Something is wrong with the default Schedule.", e);
        }
        schedule.modulesEdited();
    }

    public void asynchroneousFeedback(Schedule schedule, Replay replay) {
        if (this.tempFiles == null) {
            return;
        }
        try {
            long now = System.currentTimeMillis();
            if (now - this.lastSave > this.saveInterval) {
                FreakFile currentState = new FreakFile(replay, schedule);
                File tempFile = this.tempFiles[this.nextTempFile];
                Freak.debug("Writing backup to " + tempFile, 1);
                currentState.write(new FileOutputStream(tempFile));
                this.nextTempFile = (this.nextTempFile + 1) % this.tempFiles.length;
                this.lastSave = now;
            }
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    public void synchroneousFeedback(Schedule activeSchedule, Replay replay) {
    }

    public void simulationCompleted(Actions.Action lastProcessed) {
        Freak.debug("Run ended " + this.loadFile, 2);
        try {
            try {
                if (this.saveFile != null) {
                    FreakFile save = this.runControl.toFile();
                    save.write(new FileOutputStream(this.saveFile));
                    Freak.debug("Results written to " + this.saveFile, 1);
                }
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
        }
        finally {
            this.runControl.request(new Actions.TerminateAction());
        }
    }

    public void simulationException(Exception exc) {
        this.saveFile = null;
        exc.printStackTrace();
    }

    public void terminated(Actions.Action lastProcessedBeforeTermination) {
        Freak.debug("Bye Bye", 4);
        this.terminated = true;
        if (launchedFromR) {
            this.runControl = null;
        } else {
            System.exit(0);
        }
    }

    public static void setRMode() {
        launchedFromR = true;
        Freak.debug("Setting class \"LogRegInterface\" to R-Mode", 4);
    }

    public static void setNormalMode() {
        launchedFromR = false;
        Freak.debug("Setting class \"LogRegInterface\" to Normal Mode", 4);
    }

    public static void rSetSchedule(Schedule sched) {
        scheduleWillBeSetByR = true;
        rSchedule = sched;
        Freak.debug("Schedule has been set from R", 4);
    }

    public static void setScheduleWillBeSetByR(boolean scheduleWillBeSetByR) {
        LogRegInterface.scheduleWillBeSetByR = scheduleWillBeSetByR;
    }
}

