/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.applications.branchandbound.tsp.utilities.upperbounds.cappello;

import edu.ucsb.cs.jicos.applications.branchandbound.BranchAndBound;
import edu.ucsb.cs.jicos.applications.branchandbound.Solution;
import edu.ucsb.cs.jicos.applications.branchandbound.tsp.utilities.upperbounds.cappello.Node;
import edu.ucsb.cs.jicos.applications.branchandbound.tsp.utilities.upperbounds.cappello.Path;
import edu.ucsb.cs.jicos.applications.branchandbound.tsp.utilities.upperbounds.matching.Matching;
import edu.ucsb.cs.jicos.applications.utilities.graph.Graph;
import edu.ucsb.cs.jicos.applications.utilities.graph.GraphEuclidean;
import edu.ucsb.cs.jicos.applications.utilities.graph.GraphImpl;
import edu.ucsb.cs.jicos.examples.tsp.TSP;
import edu.ucsb.cs.jicos.examples.tsp.TspSolution;
import edu.ucsb.cs.jicos.services.Client2Hsp;
import edu.ucsb.cs.jicos.services.Environment;
import edu.ucsb.cs.jicos.services.HspAgent;
import edu.ucsb.cs.jicos.services.shared.IntUpperBound;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UpperBound {
    private static final int K = 4;
    private static final int DUMMY_DISTANCE = 1000000;
    private static final int BIG_DISTANCE = 1000000;
    private int[][] costs;
    private boolean hasDummy;
    private Path[] paths;
    private int[] tour;
    private int[] weightsIndex2CostsIndex;
    private int[] weightsIndex2PathsIndex;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$applications$branchandbound$tsp$utilities$upperbounds$cappello$UpperBound;

    public UpperBound(int[][] nArray) {
        if (nArray.length < 3) {
            throw new IllegalArgumentException("distances.length must be > 2.");
        }
        this.costs = nArray;
    }

    public int[] getTour() {
        if (this.tour == null) {
            this.tour = this.setTour();
        }
        return this.tour;
    }

    private int[] setTour() {
        int[][] nArray = this.initializeProblem();
        while (nArray.length > 4) {
            GraphImpl graphImpl = new GraphImpl(nArray);
            int[] nArray2 = graphImpl.getMinCostMaxMatch();
            this.connectMatedPaths(nArray2);
            nArray = this.setNextMatchProblem();
        }
        if (!$assertionsDisabled && this.paths.length > 4) {
            throw new AssertionError();
        }
        return this.minCostTour();
    }

    private void connectMatedPaths(int[] nArray) {
        int n;
        ArrayList<Path> arrayList = new ArrayList<Path>();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (!(n2 > nArray[n2] || this.hasDummy && nArray[n2] == nArray.length - 1)) {
                int n3;
                n = this.weightsIndex2PathsIndex[n2];
                int n4 = this.weightsIndex2PathsIndex[nArray[n2]];
                int n5 = this.weightsIndex2CostsIndex[n2];
                int n6 = this.weightsIndex2CostsIndex[nArray[n2]];
                int n7 = this.paths[n].i();
                if (n5 != n7) {
                    n7 = this.paths[n].j();
                }
                if (n6 != (n3 = this.paths[n4].i())) {
                    n3 = this.paths[n4].j();
                }
                this.paths[n2].add(n7, this.paths[n4], n3);
                arrayList.add(this.paths[n2]);
            }
            ++n2;
        }
        this.paths = (Path[])arrayList.toArray();
        System.out.println("connectMatedPaths: new paths.length: " + this.paths.length);
        System.out.println("connectMatedPaths: paths.length: " + this.paths.length);
        n = 0;
        while (n < this.paths.length) {
            System.out.println("connectMatedPaths: i: " + n + " path.id: " + this.paths[n].id() + " path.cost: " + this.paths[n].cost() + " start vertex: " + this.paths[n].i() + " end vertex: " + this.paths[n].j());
            ++n;
        }
    }

    private void copyPath2Tour(List list, int[] nArray, int n) {
        Iterator iterator = list.iterator();
        int n2 = n;
        while (iterator.hasNext()) {
            nArray[n2] = (Integer)iterator.next();
            ++n2;
        }
    }

    private int[] expandSkeleton(int[] nArray, Orientation orientation) {
        int[] nArray2 = new int[this.costs.length];
        int n = orientation.getOrientations();
        int n2 = 0;
        int n3 = 0;
        while (n2 < nArray.length) {
            Path path = this.paths[nArray[n2]];
            List list = n % 2 == 0 ? path.list() : path.reverse();
            this.copyPath2Tour(list, nArray2, n3);
            n3 += list.size();
            n >>= 1;
            ++n2;
        }
        return nArray2;
    }

    private Orientation getMinPathOrientation(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            n += this.paths[n2].cost();
            ++n2;
        }
        int n3 = 1;
        int n4 = 0;
        while (n4 < nArray.length) {
            n3 *= 2;
            ++n4;
        }
        int n5 = Integer.MAX_VALUE;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            int n8 = n;
            int n9 = n7 % 2 == 0 ? this.paths[nArray[0]].i() : this.paths[nArray[0]].j();
            int n10 = n7 % 2 == 0 ? this.paths[nArray[0]].j() : this.paths[nArray[0]].i();
            int n11 = 1;
            int n12 = n7 >> 1;
            while (n11 < nArray.length) {
                int n13 = this.paths[nArray[n11]].i();
                int n14 = this.paths[nArray[n11]].j();
                int n15 = n12 % 2 == 0 ? n13 : n14;
                n8 += this.costs[n10][n15];
                n10 = n12 % 2 == 0 ? n14 : n13;
                ++n11;
                n12 >>= 1;
            }
            if ((n8 += this.costs[n10][n9]) < n5) {
                n5 = n8;
                n6 = n7;
            }
            ++n7;
        }
        return new Orientation(n6, n5);
    }

    private int[][] initializeProblem() {
        this.paths = new Path[this.costs.length];
        int n = 0;
        while (n < this.costs.length) {
            this.paths[n] = new Path(n, this.costs);
            ++n;
        }
        return this.setNextMatchProblem();
    }

    private Node[] makeNodesArray() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.paths.length) {
            ++n;
            if (this.paths[n2].i() != this.paths[n2].j()) {
                ++n;
            }
            ++n2;
        }
        Node[] nodeArray = new Node[n];
        this.weightsIndex2CostsIndex = new int[nodeArray.length];
        this.weightsIndex2PathsIndex = new int[this.paths.length];
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.paths.length) {
            this.weightsIndex2PathsIndex[n4] = n3;
            nodeArray[n4] = this.paths[n3].nodeI();
            this.weightsIndex2CostsIndex[n4] = this.paths[n3].i();
            ++n4;
            if (this.paths[n3].i() != this.paths[n3].j()) {
                this.weightsIndex2PathsIndex[n4] = n3;
                nodeArray[n4] = this.paths[n3].nodeJ();
                this.weightsIndex2CostsIndex[n4] = this.paths[n3].j();
                ++n4;
            }
            ++n3;
        }
        return nodeArray;
    }

    private int[][] makeWeightsArray(Node[] nodeArray) {
        int n;
        int n2 = nodeArray.length;
        this.hasDummy = false;
        if (nodeArray.length % 2 == 1 && nodeArray.length > 4) {
            ++n2;
            this.hasDummy = true;
        }
        int[][] nArray = new int[n2][n2];
        int n3 = 0;
        while (n3 < nodeArray.length) {
            nArray[n3][n3] = 0;
            n = 0;
            while (n < n3) {
                if (nodeArray[n3].getMyPath() == nodeArray[n].getMyPath()) {
                    nArray[n3][n] = 1000000;
                } else {
                    int n4 = nodeArray[n3].getCostsIndex();
                    int n5 = nodeArray[n].getCostsIndex();
                    int n6 = this.costs[n4][n5];
                    nArray[n][n3] = n6;
                    nArray[n3][n] = n6;
                }
                ++n;
            }
            ++n3;
        }
        if (this.hasDummy) {
            n = 0;
            while (n < nArray.length - 1) {
                nArray[nArray.length - 1][n] = 1000000;
                nArray[n][nArray.length - 1] = 1000000;
                ++n;
            }
            nArray[nArray.length - 1][nArray.length - 1] = 0;
        }
        return nArray;
    }

    private int[] minCostTour() {
        if (!($assertionsDisabled || 2 < this.paths.length && this.paths.length <= 4)) {
            throw new AssertionError();
        }
        switch (this.paths.length) {
            case 3: {
                return this.tour3();
            }
            case 4: {
                return this.tour4();
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return new int[0];
    }

    private int[][] setNextMatchProblem() {
        Node[] nodeArray = this.makeNodesArray();
        return this.makeWeightsArray(nodeArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Matching tour: ");
        int n = 0;
        while (n < this.tour.length) {
            stringBuffer.append(this.tour[n]);
            stringBuffer.append(" ");
            ++n;
        }
        return new String(stringBuffer);
    }

    private int[] tour3() {
        int[] nArray = new int[]{0, 1, 2};
        Orientation orientation = this.getMinPathOrientation(nArray);
        return this.expandSkeleton(nArray, orientation);
    }

    private int[] tour4() {
        int[] nArray = new int[]{0, 1, 2, 3};
        Orientation orientation = this.getMinPathOrientation(nArray);
        int n = orientation.getCost();
        int[] nArray2 = new int[]{0, 1, 3, 2};
        Orientation orientation2 = this.getMinPathOrientation(nArray2);
        int n2 = orientation.getCost();
        int[] nArray3 = new int[]{0, 2, 1, 3};
        Orientation orientation3 = this.getMinPathOrientation(nArray3);
        int n3 = orientation.getCost();
        if (n <= n2) {
            if (n <= n3) {
                return this.expandSkeleton(nArray, orientation);
            }
            return this.expandSkeleton(nArray3, orientation3);
        }
        if (n2 < n3) {
            return this.expandSkeleton(nArray2, orientation2);
        }
        return this.expandSkeleton(nArray3, orientation3);
    }

    public static void main(String[] stringArray) throws Exception {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        UpperBound.compareToMatching(n, n2, n3, true);
    }

    private static void compareToMatching(int n, int n2, int n3, boolean bl) throws Exception {
        if (bl) {
            System.out.println("Random GENERAL graphs.");
        } else {
            System.out.println("Random EUCLIDEAN graphs.");
        }
        System.out.println("\tNodes\tMatch\tTime\tOPT\tTime\tMatching/Opt");
        float f = 0.0f;
        String string = "lysander";
        HspAgent hspAgent = new HspAgent(string);
        Client2Hsp client2Hsp = hspAgent.getClient2Hsp();
        int n4 = n;
        while (n4 <= n2) {
            int n5;
            int n6 = n5 = n4;
            int n7 = 1000;
            Graph graph = bl ? new GraphImpl(n5, n6, n7) : new GraphEuclidean(n5, n6, n7);
            int[][] nArray = graph.getCosts();
            System.out.print("\t" + n4);
            Matching matching = new Matching(nArray);
            long l = System.currentTimeMillis();
            matching.setTour();
            long l2 = System.currentTimeMillis();
            int[] nArray2 = matching.getTour();
            int n8 = UpperBound.getCost(nArray2, nArray);
            System.out.print("\t" + n8 + "\t" + (l2 - l));
            TSP tSP = new TSP(graph);
            IntUpperBound intUpperBound = new IntUpperBound(n8);
            Environment environment = new Environment(tSP, intUpperBound);
            TspSolution tspSolution = new TspSolution(n5);
            BranchAndBound branchAndBound = new BranchAndBound(tspSolution);
            client2Hsp.login(environment);
            l = System.currentTimeMillis();
            Solution solution = (Solution)client2Hsp.compute(branchAndBound);
            l2 = System.currentTimeMillis();
            if (solution == null) {
                System.out.println("\tNULL");
            } else {
                int n9 = ((TspSolution)solution).getCost();
                System.out.print("\t" + n9 + "\t" + (l2 - l));
                float f2 = (float)n8 / (float)n9;
                System.out.println("\t" + f2);
            }
            client2Hsp.logout();
            n4 += n3;
        }
    }

    private static int getCost(int[] nArray, int[][] nArray2) {
        int n = 0;
        int n2 = nArray[0];
        int n3 = 1;
        while (n3 < nArray.length) {
            n += nArray2[n2][nArray[n3]];
            n2 = nArray[n3];
            ++n3;
        }
        return n += nArray2[n2][nArray[0]];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$edu$ucsb$cs$jicos$applications$branchandbound$tsp$utilities$upperbounds$cappello$UpperBound == null ? (class$edu$ucsb$cs$jicos$applications$branchandbound$tsp$utilities$upperbounds$cappello$UpperBound = UpperBound.class$("edu.ucsb.cs.jicos.applications.branchandbound.tsp.utilities.upperbounds.cappello.UpperBound")) : class$edu$ucsb$cs$jicos$applications$branchandbound$tsp$utilities$upperbounds$cappello$UpperBound).desiredAssertionStatus();
    }

    private class Orientation {
        private int orientations;
        private int cost;

        Orientation(int n, int n2) {
            this.orientations = n;
            this.cost = n2;
        }

        int getCost() {
            return this.cost;
        }

        int getOrientations() {
            return this.orientations;
        }
    }
}

