/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer;

import freak.core.control.Schedule;
import freak.core.event.EventListener;
import freak.core.event.IndividualListEvent;
import freak.core.event.IndividualListEventListener;
import freak.core.event.RunEvent;
import freak.core.event.RunEventListener;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.observer.AbstractObserver;
import freak.core.population.Individual;
import freak.core.population.IndividualList;

public class QualityGain
extends AbstractObserver
implements IndividualListEventListener,
RunEventListener,
Configurable {
    private Double lastAverageFitness;

    public QualityGain(Schedule schedule) {
        super(schedule);
        this.setMeasure(1);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This module works on single objective fitness functions only.");
        }
    }

    public Class getOutputDataType() {
        return double[].class;
    }

    public String getName() {
        return "Quality Gain";
    }

    public String getDescription() {
        return "Computes the difference between the current average fitness and last generation's average fitness";
    }

    public void individualList(IndividualListEvent evt) {
        IndividualList individualList = evt.getIndividualList();
        Individual[] individuals = individualList.toArray();
        double sum = 0.0;
        int i = 0;
        while (i < individuals.length) {
            sum += ((SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction()).evaluate(individuals[i], individualList);
            ++i;
        }
        double average = sum / (double)individuals.length;
        double result = 0.0;
        if (this.lastAverageFitness != null) {
            result = average - this.lastAverageFitness;
        }
        this.lastAverageFitness = new Double(average);
        this.updateViews(new Double(result));
    }

    public void runStarted(RunEvent evt) {
        this.lastAverageFitness = null;
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent(this, "Get individuals from", IndividualListEvent.class, this.schedule.getPopulationManager());
        this.schedule.getEventController().addEvent((EventListener)this, RunEvent.class, this.schedule);
    }
}

