/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.crossover.common;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.searchspace.HasDimension;
import freak.core.searchspace.SearchSpace;
import freak.module.operator.crossover.MultiPairwiseCrossover;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import freak.module.searchspace.GeneralString;
import freak.module.searchspace.GeneralStringGenotype;
import java.util.BitSet;

public class PoissonCrossover
extends MultiPairwiseCrossover
implements Configurable,
CompatibleWithDifferentSearchSpaces {
    protected double prob;
    private int nextPos;
    private int doubleImprecision;
    private double logbasis;

    public PoissonCrossover(OperatorGraph graph) {
        super(graph);
        this.setPropertyProb(new Double(0.1));
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        SearchSpace searchspace = schedule.getGenotypeSearchSpace();
        if (!(searchspace instanceof GeneralString) && !(searchspace instanceof BitString)) {
            throw new UnsupportedEnvironmentException("Wrong searchspace");
        }
    }

    public void setPropertyProb(Double prob) {
        if (prob >= 0.0 && prob <= 1.0) {
            this.prob = prob;
            this.nextPos = -1;
            this.logbasis = Math.log(1.0 - this.prob);
            this.doubleImprecision = this.logbasis == 0.0 ? Integer.MAX_VALUE : (int)Math.floor(Math.log(Math.pow(2.0, -47.0)) / this.logbasis);
        }
    }

    public Double getPropertyProb() {
        return new Double(this.prob);
    }

    public String getLongDescriptionForProb() {
        return "The probability that each position becomes a crossing point";
    }

    public String getShortDescriptionForProb() {
        return "Probability";
    }

    private int savePos(int pos, int max) {
        if (pos > max) {
            this.nextPos = pos - max - 1;
            return -1;
        }
        this.nextPos = -1;
        return pos;
    }

    protected int getNextPosition(int max) {
        if (this.nextPos >= 0) {
            return this.savePos(this.nextPos, max);
        }
        RandomElement re = this.graph.getSchedule().getRandomElement();
        int nextPosition = this.logbasis == 0.0 ? -1 : (int)Math.floor(Math.log(re.raw()) / this.logbasis);
        if (this.doubleImprecision < nextPosition) {
            nextPosition = max > this.doubleImprecision ? this.getNextPosition(max - this.doubleImprecision - 1) + this.doubleImprecision + 1 : -1;
        }
        return this.savePos(nextPosition, max);
    }

    protected Individual doCrossover(Individual ind1, Individual ind2) {
        SearchSpace searchspace = this.graph.getSchedule().getGenotypeSearchSpace();
        int dimension = ((HasDimension)((Object)searchspace)).getDimension();
        if (searchspace instanceof BitString) {
            BitSet bs1 = ((BitStringGenotype)ind1.getGenotype()).getBitSet();
            BitSet bs2 = ((BitStringGenotype)ind2.getGenotype()).getBitSet();
            BitSet bsOut = (BitSet)bs1.clone();
            int i = 0;
            while (i < dimension) {
                int j = this.getNextPosition(dimension - i - 1);
                if (j != -1) {
                    int secEnd;
                    if ((secEnd = this.getNextPosition(dimension - (i += j) - 2) + i + 1) == i) {
                        secEnd = dimension;
                    }
                    while (i < secEnd) {
                        bsOut.set(i, bs2.get(i));
                        ++i;
                    }
                    ++i;
                    continue;
                }
                i = dimension;
            }
            return new Individual(this.graph.getSchedule(), new BitStringGenotype(bsOut, dimension), new Individual[]{ind1, ind2});
        }
        int[] bs1 = ((GeneralStringGenotype)ind1.getGenotype()).getIntArray();
        int[] bs2 = ((GeneralStringGenotype)ind2.getGenotype()).getIntArray();
        int numChars = ((GeneralString)searchspace).getNumChars();
        int[] bsOut = (int[])bs1.clone();
        int i = 0;
        while (i < dimension) {
            int j = this.getNextPosition(dimension - i - 1);
            if (j != -1) {
                int secEnd;
                if ((secEnd = this.getNextPosition(dimension - (i += j) - 2) + i + 1) == i) {
                    secEnd = dimension;
                }
                while (i < secEnd) {
                    bsOut[i] = bs2[i];
                    ++i;
                }
                ++i;
                continue;
            }
            i = dimension;
        }
        return new Individual(this.graph.getSchedule(), new GeneralStringGenotype(bsOut, numChars), new Individual[]{ind1, ind2});
    }

    public String getDescription() {
        return "Each position becomes a crossing point with probability prob.";
    }

    public String getName() {
        return "Poisson Crossover";
    }
}

