/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.mutation.cycle;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.graph.Mutation;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.Configurable;
import freak.core.population.Individual;
import freak.core.searchspace.HasDimension;
import freak.core.util.FreakMath;
import freak.module.searchspace.Cycle;
import freak.module.searchspace.PermutationGenotype;

public class KOpt
extends Mutation
implements Configurable {
    private int k = 2;

    public KOpt(OperatorGraph graph) {
        super(graph);
    }

    public void initialize() {
        super.initialize();
        int dim = ((HasDimension)((Object)this.getGenotypeSearchSpace())).getDimension();
        if (this.k > dim) {
            this.k = dim;
        }
    }

    public Integer getPropertyK() {
        return new Integer(this.k);
    }

    public void setPropertyK(Integer k) {
        int dim = ((Cycle)this.graph.getSchedule().getGenotypeSearchSpace()).getDimension();
        int tmp = k;
        if (tmp > 2 && tmp <= dim) {
            this.k = tmp;
        }
    }

    public String getLongDescriptionForK() {
        return "Number of segments for reordering in the cycle.";
    }

    public String getShortDescriptionForK() {
        return "k";
    }

    protected Individual doMutation(Individual ind) {
        int small;
        RandomElement re = this.graph.getSchedule().getRandomElement();
        int[] tour = ((PermutationGenotype)ind.getGenotype()).getIntArray();
        int[] mutTour = new int[tour.length];
        int[] pos = FreakMath.getKofN(this.graph.getSchedule(), this.k, tour.length);
        int[] perm = FreakMath.getKofN(this.graph.getSchedule(), this.k, this.k);
        boolean[] reverse = new boolean[this.k];
        int i = 0;
        while (i < this.k) {
            reverse[i] = re.choose(2) == 1;
            ++i;
        }
        int big = perm[0] > perm[1] ? perm[0] : perm[1];
        int n = small = perm[0] < perm[1] ? perm[0] : perm[1];
        if ((big - small == 1 || big - small == perm.length - 1) && reverse[0] == reverse[1]) {
            reverse[0] = !reverse[0];
        }
        int mutI = 0;
        int i2 = 0;
        while (i2 < this.k) {
            int intervalSize = (pos[(perm[i2] + 1) % this.k] - pos[perm[i2]] + tour.length) % tour.length;
            int j = 0;
            while (j < intervalSize) {
                mutTour[mutI++] = reverse[i2] ? tour[(pos[(perm[i2] + 1) % this.k] - j - 1 + tour.length) % tour.length] : tour[(pos[perm[i2]] + j) % tour.length];
                ++j;
            }
            ++i2;
        }
        return new Individual(this.graph.getSchedule(), new PermutationGenotype(mutTour), new Individual[]{ind});
    }

    public String getDescription() {
        return "The k-Opt operator cuts the permutation into k segments and then reorders the segments. Each segment can be placed in a forward or reverse order.";
    }

    public String getName() {
        return "k-Opt";
    }
}

