/*
 * Decompiled with CFR 0.152.
 */
package javalain.tribes;

import java.util.ArrayList;
import javalain.math.Calcul;
import javalain.tribes.EssaimTribe;
import javalain.tribes.ParticuleTribes;

public class TribuTribes {
    private EssaimTribe swarm;
    private ArrayList<ParticuleTribes> tribe;
    private ArrayList<TribuTribes> lien;

    public TribuTribes(EssaimTribe swarm) {
        this.swarm = swarm;
        this.tribe = new ArrayList();
        this.lien = new ArrayList();
    }

    public TribuTribes getLien(int i) {
        return this.lien.get(i);
    }

    public void addLien(TribuTribes t) {
        this.lien.add(t);
    }

    public void removeLien(TribuTribes tr) {
        this.lien.remove(tr);
    }

    public int nbLiens() {
        return this.lien.size();
    }

    public void addParticule(ParticuleTribes p) {
        this.tribe.add(p);
    }

    public int size() {
        return this.tribe.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updatePosition() {
        ParticuleTribes shaman = this.getBestParticleOfTribe();
        for (int i = 0; i < this.tribe.size(); ++i) {
            ParticuleTribes informatrice;
            ParticuleTribes particule = this.tribe.get(i);
            if (particule == shaman) {
                int choix = Calcul.randomInt(this.swarm.getNbTribus());
                if (this == this.swarm.getTribu(choix)) return;
                informatrice = this.swarm.getTribu(choix).getBestParticleOfTribe();
            } else {
                informatrice = shaman;
            }
            particule.updatePosition(informatrice);
        }
    }

    public void updateBest() {
        for (int i = 0; i < this.tribe.size(); ++i) {
            this.tribe.get(i).updateBest();
        }
    }

    public boolean isGood() {
        int nb = 0;
        for (int i = 0; i < this.tribe.size(); ++i) {
            if (!this.tribe.get(i).isGood()) continue;
            ++nb;
        }
        return (double)nb > (double)this.tribe.size() * Math.random();
    }

    public ParticuleTribes getBestParticleOfTribe() {
        int pos = 0;
        double max = this.tribe.get((int)0).bestPerf;
        for (int i = 1; i < this.tribe.size(); ++i) {
            if (!(max < this.tribe.get((int)i).bestPerf)) continue;
            pos = i;
            max = this.tribe.get((int)i).bestPerf;
        }
        return this.tribe.get(pos);
    }

    public void supprimePireParticule() {
        int pos = 0;
        double min = this.tribe.get((int)0).bestPerf;
        for (int i = 1; i < this.tribe.size(); ++i) {
            if (!(min > this.tribe.get((int)i).bestPerf)) continue;
            pos = i;
            min = this.tribe.get((int)i).bestPerf;
        }
        this.tribe.remove(pos);
    }
}

