/*
 * Decompiled with CFR 0.152.
 */
package epp_pso.tribe;

import indice.Indice;
import javalain.math.Calcul;
import util.GuiUtils;

public class ParticuleTribe {
    public static final int MEILLEURE = 0;
    public static final int STATU_QUO = 1;
    public static final int MAUVAISE = 2;
    public static final int BONNE = 5;
    public static final int NEUTRE = 6;
    private final Indice indice;
    private final int P;
    public double I;
    public double meilleurI;
    public double[] projectionCourante;
    public double[] meilleureProjection;
    public int performance_prec;
    public int performance_crt;
    public int qualite;

    public ParticuleTribe(Indice ind) {
        this.indice = ind;
        this.P = ind.getNombreParametres();
        this.projectionCourante = new double[this.P];
        this.meilleureProjection = new double[this.P];
        for (int i = 0; i < this.P; ++i) {
            this.projectionCourante[i] = Math.random() * 2.0 - 1.0;
            this.meilleureProjection[i] = 0.0;
        }
        this.projectionCourante = Calcul.normaliseVecteur((double[])this.projectionCourante);
        this.meilleurI = Double.NEGATIVE_INFINITY;
        this.performance_prec = 1;
        this.performance_crt = 1;
        this.qualite = 6;
    }

    public ParticuleTribe(Indice ind, ParticuleTribe globalBest, ParticuleTribe bestParticule) {
        this.indice = ind;
        this.P = ind.getNombreParametres();
        this.projectionCourante = Calcul.loiHyperspherique((double[])globalBest.meilleureProjection, (double[])bestParticule.meilleureProjection);
        this.meilleureProjection = new double[this.P];
        for (int i = 0; i < this.P; ++i) {
            this.meilleureProjection[i] = 0.0;
        }
        this.projectionCourante = Calcul.normaliseVecteur((double[])this.projectionCourante);
        this.meilleurI = Double.NEGATIVE_INFINITY;
        this.performance_prec = 1;
        this.performance_crt = 1;
        this.qualite = 6;
    }

    public void updatePbest() {
        double d = this.I;
        this.I = this.indice.calcul(this.projectionCourante);
        this.performance_crt = 1;
        if (this.I > this.meilleurI) {
            this.meilleurI = this.I;
            System.arraycopy(this.projectionCourante, 0, this.meilleureProjection, 0, this.P);
            this.performance_crt = 0;
        }
    }

    public void calculNouvellePosition(ParticuleTribe globalBest, boolean bool, int N) {
        boolean verif = false;
        if (this.performance_prec == 2 && this.performance_crt == 2 || this.performance_prec == 1 && this.performance_crt == 2 || this.performance_prec == 2 && this.performance_crt == 1 || this.performance_prec == 1 && this.performance_crt == 1 || this.performance_prec == 0 && this.performance_crt == 2) {
            verif = true;
        }
        if (verif && !bool) {
            this.pivot(globalBest);
        }
        if (this.performance_prec == 0 && this.performance_crt == 1 || this.performance_prec == 2 && this.performance_crt == 0) {
            this.pivotBruite(globalBest);
        }
        if (this.performance_prec == 1 && this.performance_crt == 0 || this.performance_prec == 0 && this.performance_crt == 0) {
            this.gaussienneIndependante(globalBest);
        }
        if (verif && bool) {
            this.EDA(N);
        }
        this.performance_prec = this.performance_crt;
        this.projectionCourante = Calcul.normaliseVecteur((double[])this.projectionCourante);
    }

    public void pivot(ParticuleTribe globalBest) {
        double c2 = this.meilleurI / (this.meilleurI + globalBest.meilleurI);
        double c3 = globalBest.meilleurI / (this.meilleurI + globalBest.meilleurI);
        double[] alea_Hp = Calcul.loiHyperspherique((double[])this.meilleureProjection, (double[])globalBest.meilleureProjection);
        double[] alea_Hg = Calcul.loiHyperspherique((double[])globalBest.meilleureProjection, (double[])this.meilleureProjection);
        for (int i = 0; i < this.P; ++i) {
            this.projectionCourante[i] = c2 * alea_Hp[i] + c3 * alea_Hg[i];
        }
    }

    public void pivotBruite(ParticuleTribe globalBest) {
        this.pivot(globalBest);
        double sigma = (this.meilleurI - globalBest.meilleurI) / (this.meilleurI + globalBest.meilleurI);
        double c = Calcul.loiNormale((double)0.0, (double)sigma);
        for (int i = 0; i < this.P; ++i) {
            this.projectionCourante[i] = (1.0 + c) * this.projectionCourante[i];
        }
    }

    public void gaussienneIndependante(ParticuleTribe globalBest) {
        for (int i = 0; i < this.P; ++i) {
            double d = globalBest.meilleureProjection[i] - this.projectionCourante[i];
            double sigma = Math.abs(globalBest.meilleureProjection[i] - this.projectionCourante[i]);
            this.projectionCourante[i] = this.meilleureProjection[i] + Calcul.loiNormale((double)d, (double)sigma);
        }
    }

    public void EDA(int N) {
        for (int i = 0; i < this.P; ++i) {
            int j;
            double som = 0.0;
            for (j = 0; j < N; ++j) {
                som += this.meilleureProjection[j];
            }
            double c = 1.0 / (double)N * som;
            som = 0.0;
            for (j = 1; j < N; ++j) {
                som += Calcul.pow2((double)(this.meilleureProjection[j] - c));
            }
            double sigma = Math.sqrt(1.0 / (double)(N - 1) * som);
            this.projectionCourante[i] = Calcul.loiNormale((double)c, (double)sigma);
        }
    }

    public ParticuleTribe createCopie() {
        ParticuleTribe p = new ParticuleTribe(this.indice);
        p.I = this.I;
        p.meilleurI = this.meilleurI;
        for (int i = 0; i < this.P; ++i) {
            p.projectionCourante[i] = this.projectionCourante[i];
            p.meilleureProjection[i] = this.meilleureProjection[i];
        }
        p.performance_prec = this.performance_prec;
        return p;
    }

    public String toString() {
        int i;
        StringBuilder s = new StringBuilder();
        s.append("----- Particule (").append(this.P).append(")\n");
        s.append("I                    : ").append(GuiUtils.DECIMAL_12.format(this.I)).append("\n");
        s.append("Meilleur I           : ").append(GuiUtils.DECIMAL_12.format(this.meilleurI)).append("\n");
        s.append("Projection courante  : ");
        for (i = 0; i < this.P - 1; ++i) {
            s.append(GuiUtils.DECIMAL_12.format(this.projectionCourante[i])).append(", ");
        }
        s.append(GuiUtils.DECIMAL_12.format(this.projectionCourante[this.P - 1])).append("\n");
        s.append("Meilleure projection : ");
        for (i = 0; i < this.P - 1; ++i) {
            s.append(GuiUtils.DECIMAL_12.format(this.meilleureProjection[i])).append(", ");
        }
        s.append(GuiUtils.DECIMAL_12.format(this.meilleureProjection[this.P - 1])).append("\n");
        s.append("-----");
        return s.toString();
    }
}

