% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{Search}
\alias{Search}
\title{"Search"}
\usage{
Search(WhatToLookFor = data.frame(GeneID = NULL, ExonID = NULL), Data,
  AggregateResults = FALSE, NotFound = NULL)
}
\arguments{
\item{WhatToLookFor}{A data frame with a GeneID and ExonID column. Only the ExonID column is necessary, the corresponding gene ID will be sought in the data}

\item{Data}{The data in which the given gene and exon ID should be sought.}

\item{AggregateResults}{Logical. Should the results be aggregated on gene level? This results in a list with one item per gene}

\item{NotFound}{Not be specified by the user.}
}
\value{
The returned value is a list with two elements. The first element is SearchResults which contains a list of the found instances in the data. The list contains an element per found instance. If AggregateResults is TRUE, the list is reduced to an element per gene. The secod is a data frame calles NotFound which contain the gene and exon ID which were not found in the data. If only exon ID were specified, the gene ID are NA in this data frame.
}
\description{
The Search function investigates whether specific genes and/or exons are present in the data. It returns the elements of the found elements and a list of those that were not found.
}
\examples{
data(TC12000010_REIDS_Output)
Test_F=FilterInformativeGenes(TC12000010_REIDS_Output)
Test_S=Search(WhatToLookFor=data.frame(ExonID=c("PSR12000150")),Data=Test_F,
AggregateResults=FALSE,NotFound=NULL)
}
