% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{multi_choice_to_labels}
\alias{multi_choice_to_labels}
\title{Update multiple choice fields with label data}
\usage{
multi_choice_to_labels(
  db_data,
  db_metadata,
  raw_or_label = "label",
  call = caller_env()
)
}
\arguments{
\item{db_data}{A REDCap database object}

\item{db_metadata}{A REDCap metadata object}

\item{raw_or_label}{A string (either 'raw', 'label', or 'haven') that specifies whether
to export the raw coded values or the labels for the options of categorical
fields. Default is 'label'. If 'haven' is supplied, categorical fields are converted
to \code{haven_labelled} vectors.}

\item{call}{call for conditions}
}
\description{
Update REDCap variables with multi-choice types to standard form labels taken
from REDCap metadata.
}
\details{
Coerce variables of \code{field_type} "truefalse", "yesno", and "checkbox" to
logical. Introduce \code{form_status_complete} column and append to end of
\code{tibble} outputs. Ensure \code{field_type}s "dropdown" and "radio" are
converted appropriately since label appendings are important and unique to
these.
}
\keyword{internal}
