% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_redcap.R
\name{read_redcap}
\alias{read_redcap}
\title{Import a REDCap database into a tidy supertibble}
\usage{
read_redcap(
  redcap_uri,
  token,
  raw_or_label = "label",
  forms = NULL,
  export_survey_fields = NULL,
  export_data_access_groups = NULL,
  suppress_redcapr_messages = TRUE,
  guess_max = .Machine$integer.max,
  allow_mixed_structure = getOption("redcaptidier.allow.mixed.structure", FALSE)
)
}
\arguments{
\item{redcap_uri}{The
URI/URL of the REDCap server (e.g.,
"https://server.org/apps/redcap/api/"). Required.}

\item{token}{The user-specific string that serves as the password for a
project. Required.}

\item{raw_or_label}{A string (either 'raw', 'label', or 'haven') that specifies whether
to export the raw coded values or the labels for the options of categorical
fields. Default is 'label'. If 'haven' is supplied, categorical fields are converted
to \code{haven_labelled} vectors.}

\item{forms}{A character vector of REDCap instrument names that specifies
which instruments to import. Default is \code{NULL} which imports all instruments
in the project.}

\item{export_survey_fields}{A logical that specifies whether to export
survey identifier and timestamp fields. The default, \code{NULL},
tries to determine if survey fields exist and returns them if available.}

\item{export_data_access_groups}{A logical that specifies whether to export
the data access group field. The default, \code{NULL}, tries to determine if a data
access group field exists and returns it if available.}

\item{suppress_redcapr_messages}{A logical to control whether to suppress messages
from REDCapR API calls. Default \code{TRUE}.}

\item{guess_max}{A positive \link[base:numeric]{base::numeric} value
passed to \code{\link[readr:read_delim]{readr::read_csv()}} that specifies the maximum number of records to
use for guessing column types. Default \code{.Machine$integer.max}.}

\item{allow_mixed_structure}{A logical to allow for support of mixed repeating/non-repeating
instruments. Setting to \code{TRUE} will treat the mixed instrument's non-repeating versions
as repeating instruments with a single instance. Applies to longitudinal projects
only. Default \code{FALSE}. Can be set globally with \code{options(redcaptidier.allow.mixed.structure = TRUE)}.}
}
\value{
A \code{tibble} in which each row represents a REDCap instrument. It
contains the following columns:
\itemize{
\item \code{redcap_form_name}, the name of the instrument
\item \code{redcap_form_label}, the label for the instrument
\item \code{redcap_data}, a tibble with the data for the instrument
\item \code{redcap_metadata}, a tibble of data dictionary entries for each field in the instrument
\item \code{redcap_events}, a tibble with information about the arms and longitudinal events represented in the instrument.
Only if the project has longitudinal events enabled
\item \code{structure}, the instrument structure, either "repeating" or "nonrepeating"
\item \code{data_rows}, the number of rows in the instrument's data tibble
\item \code{data_cols}, the number of columns in the instrument's data tibble
\item \code{data_size}, the size in memory of the instrument's data tibble computed by \code{lobstr::obj_size()}
\item \code{data_na_pct}, the percentage of cells in the instrument's data columns that are \code{NA} excluding identifier and
form completion columns
}
}
\description{
Query the REDCap API to retrieve data and metadata about a project,
and transform the output into a "supertibble" that contains data
and metadata organized into tibbles, broken down by instrument.
}
\details{
This function uses the \href{https://ouhscbbmc.github.io/REDCapR/index.html}{REDCapR}
package to query the REDCap API. The REDCap API returns a
\href{https://en.wikipedia.org/wiki/Block_matrix}{block matrix} that mashes
data from all data collection instruments
together. The \code{read_redcap()} function
deconstructs the block matrix and splices the data into individual tibbles,
where one tibble represents the data from one instrument.
}
\examples{
\dontrun{
redcap_uri <- Sys.getenv("REDCAP_URI")
token <- Sys.getenv("REDCAP_TOKEN")

read_redcap(
  redcap_uri,
  token,
  raw_or_label = "label"
)
}

}
