% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_redcap_long.R
\name{clean_redcap_long}
\alias{clean_redcap_long}
\title{Extract longitudinal REDCap databases into tidy tibbles}
\usage{
clean_redcap_long(db_data_long, db_metadata_long, linked_arms)
}
\arguments{
\item{db_data_long}{The longitudinal REDCap database output defined by
\code{REDCapR::redcap_read_oneshot()$data}}

\item{db_metadata_long}{The longitudinal REDCap metadata output defined by
\code{REDCapR::redcap_metadata_read()$data}}

\item{linked_arms}{Output of \code{link_arms}, linking instruments to REDCap
events/arms}
}
\value{
Returns a \code{tibble} with list elements containing tidy dataframes. Users
can access dataframes under the \code{redcap_data} column with reference to
\code{form_name} and \code{structure} column details.
}
\description{
Helper function internal to \code{read_redcap} responsible for
extraction and final processing of a tidy \code{tibble} to the user from
a longitudinal REDCap database.
}
\keyword{internal}
