% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/okresy.R
\name{okresy}
\alias{okresy}
\title{Districts (okresy)}
\format{sf data frame with 77 rows of 6 variables + geometry

\describe{
  \item{KOD_OKRES}{Code of the district (okres).}
  \item{KOD_LAU1}{Code of the district as LAU1 unit (okres), primary key. Use this as key to add other data items.}
  \item{NAZ_LAU1}{Name of the district as LAU1 unit (okres).}
  \item{KOD_KRAJ}{Code of the region.}
  \item{KOD_CZNUTS3}{Code of the region as NUTS3 (kraj).}
  \item{NAZ_CZNUTS3}{Name of the region (kraj).}
}}
\source{
\url{https://www.arcdata.cz/produkty/geograficka-data/arccr-500}
}
\usage{
okresy()
}
\description{
LAU1 administrative unit for the Czech Republic.
}
\details{
Due to package size constraints the data are stored externally (and a working internet connection is required to use the package). Downloaded size is 6.1 MB (so use with caution, and patience).

okresy() is a function taking no parameters and returning a data frame; remember to use (empty) brackets in your call.
}
\examples{
library(sf)

hranice <- okresy()
plot(hranice, col = "white", max.plot = 1)

}
