% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.functions.r
\name{wtd.hist}
\alias{wtd.hist}
\title{Creates a Histogram Showing Distribution of Variable Values With Option for Weights
Makes use of the wtd.hist function, part of the weights package.}
\usage{
wtd.hist(x, w = NULL, data, breaks, ...)
}
\arguments{
\item{x}{A variable (must be numeric), should be in dataset$var form unless dataset specified in optional data argument.}

\item{w}{Sampling weights of variable (optional), must be numeric; should be in dataset$weightvar form unless dataset specified in optional data argument.}

\item{data}{(Optional) Name of dataset that contains x (and w) variable.}

\item{breaks}{(Optional) Specifies the breakpoints between bins of the histogram. See \code{\link[weights]{wtd.hist}} documentation for details.}

\item{...}{(Optional) Additional arguments passed to weights::wtd.hist function.}
}
\value{
Generate a histogram plot.
}
\description{
Takes in variable and generates histogram plot to show the distribution of its values, works with sampling weights.
The wtd.hist function is imported from the weights package. See \code{\link[Hmisc]{wtd.stats}} documentation for details.
}
\examples{
   library(RCPA3)
   
   wtd.hist(x=nes$age, w=nes$wt)
}
\keyword{internal}
