% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterDimensions.R
\name{filterDimensions}
\alias{filterDimensions}
\title{Filter dimensions, limiting to arbitrary lon/lat/Z/time ranges}
\usage{
filterDimensions(x, lonRange = NULL, latRange = NULL, ZRange = NULL,
  yearRange = NULL, monthRange = NULL, verbose = FALSE)
}
\arguments{
\item{x}{A \code{\link{cmip5data}} object}

\item{lonRange}{Longitude values (min, max) to filter data against}

\item{latRange}{Latitude values (min, max) to filter data against}

\item{ZRange}{Z values (min, max) to filter data against}

\item{yearRange}{Years (min, max) to filter data against}

\item{monthRange}{Months (min, max) to filter data against}

\item{verbose}{logical. Print info as we go?}
}
\value{
The filtered \code{\link{cmip5data}} object.
}
\description{
We frequently want to filter CMIP5 data according to some predetermined
criteria: only high-latitude cells, for example, or certain years, months,
Zs, etc. This function provides convenient one-stop service
for such tasks.
}
\note{
If a filter is requested but no relevant data are present,
a \code{\link{warning}} will be produced.
}
\examples{
d <- cmip5data(1970:2014)   # sample data
filterDimensions(d, yearRange=c(1980, 1985))
filterDimensions(d, monthRange=c(6, 8))  # summer
filterDimensions(d, latRange=c(-20, 20))  # the tropics
filterDimensions(d, latRange=c(-20, 20), monthRange=c(6, 8))  # tropical summer
}

