% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LinksMetrics.R
\name{link_Metrics_Encoders}
\alias{link_Metrics_Encoders}
\title{Returns users who have encoded this long URL.}
\usage{
link_Metrics_Encoders(link, my_network = "false", limit = 25,
  expand_user = "false", subaccounts = "false", showRequestURL = FALSE)
}
\arguments{
\item{link}{- a Bitlink.}

\item{my_network}{- true or false (default) restrict to my network.}

\item{limit}{- 1 to 1000 (default=1000).}

\item{expand_user}{- true or false (default) include display names of encoders.}

\item{subaccounts}{- (only available to enterprise accounts) false (always default) restrict to
this enterprise account and its subaccounts}

\item{showRequestURL}{- show URL which has been build and requested from server. For debug purposes.}
}
\value{
entries - a mapping of link, user, and ts (when the Bitlink was created) and possible
more depending on input parameters.
}
\description{
Returns users who have encoded this long URL (optionally only those in the requesting
user's social graph).
}
\note{
Some users may not be returned from this call depending on Bitlink privacy settings.
}
\examples{
rbitlyApi("0906523ec6a8c78b33f9310e84e7a5c81e500909")
link_Metrics_Encoders(link = "http://bit.ly/DPetrov")
link_Metrics_Encoders(link = "http://bit.ly/DPetrov", expand_user = "true", my_network = "false")
}
\seealso{
\url{http://dev.bitly.com/link_metrics.html#v3_link_encoders}
}

