% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{run_rafs_with_fs_results}
\alias{run_rafs_with_fs_results}
\title{Robust Aggregative Feature Selection (RAFS) from feature selection results}
\usage{
run_rafs_with_fs_results(
  data,
  decision,
  fs_results,
  dist_funs = default_dist_funs,
  hclust_methods = default_hclust_methods
)
}
\arguments{
\item{data}{input data where columns are variables and rows are observations (all numeric)}

\item{decision}{decision variable as a binary sequence of length equal to number of observations}

\item{fs_results}{output from \code{\link{compute_fs_results}} computed for the same \code{data} and \code{decision}}

\item{dist_funs}{a list of feature dissimilarity functions computed over the relevant portion of the training dataset (see the example \code{\link{default_dist_funs}} to learn more)}

\item{hclust_methods}{a vector of \code{\link{hclust}} methods to use}
}
\value{
A nested \code{\link{list}} with \code{\link{hclust}} results.
  The first level is per the cross validation run.
  The second level is per the feature dissimilarity function.
  The third (and last) level is per the hclust method.
}
\description{
This is a secondary function, useful when experimenting with different
feature selection filters and rankings. The output is exactly the same as
from \code{\link{run_rafs}}.
}
\examples{
library(MDFS)
mdfs_omp_set_num_threads(1)  # only to pass CRAN checks
data(madelon)
fs_results <- compute_fs_results(madelon$data, madelon$decision, 2, c(12345))
run_rafs_with_fs_results(madelon$data, madelon$decision, fs_results)
}
