\name{bugs.script}
\alias{bugs.script}

\title{Writes script for running OpenBUGS}

\description{Write file \file{script.txt} for \pkg{OpenBUGS} to read -
  intended for internal use}

\usage{
bugs.script(parameters.to.save, n.chains, n.iter, n.burnin,
           n.thin, saveExec, restart, model.file.bug,
           model.file, debug=FALSE, is.inits, 
           DIC=FALSE, useWINE=FALSE,
           newWINE=TRUE, WINEPATH=NULL, bugs.seed=NULL, summary.only=FALSE,
           save.history=(.Platform$OS.type == "windows" | useWINE==TRUE),
           bugs.data.file, bugs.inits.files,
           over.relax = FALSE) 
}
\arguments{
  \item{parameters.to.save}{parameters that should be monitored}
  \item{n.chains}{number of Markov chains}
  \item{n.iter}{number of total iterations (including burn in)}
  \item{n.burnin}{length of burn in}
  \item{n.thin}{thinning parameter}
  \item{saveExec}{If TRUE, a re-startable image of the OpenBUGS execution is
  saved with \code{basename(model.file)} and extension .bug in the working
  directory, which must be specified.  The .bug files can be large, so 
  users should monitor them carefully and remove them when not needed.
}
  \item{restart}{If TRUE, execution resumes with the final status from
  the previous execution stored in the .bug file in the working directory.
  If \code{n.burnin=0},additional iterations are performed and all iterations since
  the previous burnin are used (including those from past executions).  If
  \code{n.burnin>0}, a new burnin is performed, and the previous iterations are 
  discarded, but execution continues from the status at the end of the previous
  execution.  When \code{restart=TRUE}, only \code{n.burnin}, \code{n.iter}, 
  and \code{saveExec} inputs 
  should be changed from the call creating the .bug file, otherwise 
  failed or erratic results may be produced.
}
  \item{model.file.bug}{If saveExec or restart is TRUE, then \code{model.file.bug}
  receives/contains the OpenBUGS program image for restarting the program.  
  \code{model.file.bug} is the name of the file with its full path
  }
  \item{model.file}{file containing the model written in \pkg{OpenBUGS} code}
  \item{debug}{if \code{FALSE}, \pkg{OpenBUGS} is closed automatically,
    otherwise \pkg{OpenBUGS} remains open for further investigation. With 
    \code{debug} = \code{TRUE}, no modelQuit() command is added to the
      end of the script, which can cause an infinite loop with linux
      execution.}
  \item{is.inits}{logical; whether initial values are given by the user
    (\code{TRUE}) or have to be generated by \pkg{OpenBUGS}}
  \item{DIC}{logical; if \code{TRUE}, compute deviance, pD, and DIC
    automatically in \pkg{OpenBUGS}}
  \item{useWINE}{as in \code{\link{bugs}} meta function}
  \item{newWINE}{as in \code{\link{bugs}} meta function}
  \item{WINEPATH}{as in \code{\link{bugs}} meta function}
  \item{bugs.seed}{random seed for \pkg{OpenBUGS} (default is no seed specified)}
  \item{summary.only}{If \code{TRUE}, only a parameter summary for very quick analyses is given, 
    temporary created files are not removed in that case.}
  \item{save.history}{If \code{TRUE} (the default), trace plots are generated at the end.}
  \item{bugs.data.file}{character name of the data file}
  \item{bugs.inits.files}{character vector of names of the inits files}  
  \item{over.relax}{If \code{TRUE}, over-relaxed form of MCMC is used if available from OpenBUGS.}
}

\value{Nothing, but as a side effect, the script file \file{script.txt}
  is written}

\seealso{The main function to be called by the user is \code{\link{bugs}}.}
\keyword{internal}
\keyword{file}
\keyword{IO}
