% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All_MUFASA_Code.R
\name{p.MUFASA}
\alias{p.MUFASA}
\title{Returns MUFASA diet estimates corresponding to a sample of predators.}
\usage{
p.MUFASA(pred.mat, prey.mat, cal.mat, FC, ext.fa)
}
\arguments{
\item{pred.mat}{matrix containing the FA signatures of the predators.}

\item{prey.mat}{matrix containing a representative FA signature
from each prey group (usually the mean). The first column must
index the prey group or species.}

\item{cal.mat}{matrix of calibration factors where the \emph{i} th
column is to be used with the \emph{i} th predator. If modelling is to be
done without calibration coefficients, simply pass a vector or matrix of
ones.}

\item{FC}{vector of fat content of length equal to the number of prey groups
or species.}

\item{ext.fa}{subset of fatty acids to be used to obtain QFASA diet estimates.}
}
\value{
A list with components:
\item{Diet_Estimates}{A matrix of the diet estimates for each predator where
each row corresponds to a predator and the columns to prey species.
The estimates are expressed as proportions summing to one.}
\item{nll}{Negative log likelihood values.  As per \emph{solnp} documentation,
           \emph{nll} is "Vector of function values during optimization with
           last one the value at the optimal".}
\item{Var_Epsilon}{Optimized values of error variance.  See reference.}
}
\description{
Computes the diet estimate for each predator in \emph{pred.mat} using MLE
method.
}
\examples{

 ##  This example takes some time to run.
 ## Please uncomment code below to run.

#library(dplyr)
#library(compositions)
 ## Fatty Acids
#data(FAset)
#fa.set = as.vector(unlist(FAset))

## Predators
#data(predatorFAs)
#tombstone.info = predatorFAs[,1:4]
#predator.matrix = predatorFAs[,5:(ncol(predatorFAs))]
#npredators = nrow(predator.matrix)

## Prey
## Extracting a small number of species to speed up calculations for the example.
#data(preyFAs)
#prey.matrix = preyFAs[,-c(1,3)]
#spec.red <-c("capelin", "herring", "mackerel", "pilchard", "sandlance")
#spec.red <- sort(spec.red)
#prey.red <- prey.matrix \%>\% filter(Species \%in\% spec.red)

## Fat content
#FC = preyFAs[,c(2,3)]
#FC = FC \%>\%  arrange(Species)
#FC.vec = tapply(FC$lipid,FC$Species,mean,na.rm=TRUE)
#FC.red <- FC.vec[spec.red]

## Calibration Coefficients
#data(CC)
#cal.vec = CC[,2]
#cal.m = replicate(npredators, cal.vec)
#rownames(cal.m) <- CC$FA

#M <- p.MUFASA(predator.matrix, prey.red, cal.m, FC.red, fa.set)

## Diet EStimates

#M$Diet_Estimates

}
\references{
Steeves, Holly (2020) Maximum likelihood approach to diet
estimation and inference based on fatty acid signatures. PhD thesis available
at https://dalspace.library.dal.ca/handle/10222/80034.
}
