% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{get_qbms_connection}
\alias{get_qbms_connection}
\title{Get the QBMS connection}
\usage{
get_qbms_connection()
}
\value{
a list of the current connection config and status
}
\description{
Get the QBMS connection object from the current environment
}
\examples{
if(interactive()) {
# configure QBMS to connect the phenotypics server
set_qbms_config("https://www.bms-uat-test.net/ibpworkbench/controller/auth/login")

# login, set the crop, and program
login_bms()
set_crop("maize")
set_program("MC Maize")

# get germplasm data
df1 <- get_germplasm_data("BASFCORN-2-1")

# save current connection (phenotypic server)
con1 <- get_qbms_connection()

# configure QBMS to connect the genotypic server
set_qbms_config("https://gigwa.southgreen.fr/gigwa/", engine = "gigwa", no_auth = TRUE)

# set the db, project, and run
gigwa_set_db("3kG_10M")
gigwa_set_project("3003_ind")
gigwa_set_run("1")

# get associated metadata
df2 <- gigwa_get_metadata()

# save current connection (before switch)
con2 <- get_qbms_connection()

# load the saved phenotypic server connection
set_qbms_connection(con1)

# continue retrieving germplasm attributes from the phenotypic server
df3 <- get_germplasm_attributes("BASFCORN-2-1")
}
}
\seealso{
\code{\link{set_qbms_connection}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
