% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QBAD.R
\name{LogLikQBAD}
\alias{LogLikQBAD}
\title{Log-likelihood function for the quantile-based asymmetric family of distributions.}
\usage{
LogLikQBAD(y, mu, phi, alpha, f)
}
\arguments{
\item{y}{This is a vector of quantiles.}

\item{mu}{This is the location parameter \eqn{\mu}.}

\item{phi}{This is the scale parameter  \eqn{\phi}.}

\item{alpha}{This is the index parameter  \eqn{\alpha}.}

\item{f}{This is the reference density function \eqn{f} which is a standard version of a unimodal and symmetric around 0 density.}
}
\value{
\code{\link{LogLikQBAD}} provides the realized value of the Log-likelihood function of quantile-based asymmetric family of distributions.
}
\description{
Log-Likelihood function \eqn{\ell_n(\mu,\phi,\alpha)=\ln[L_n(\mu,\phi,\alpha)]}
in the three parameter quantile-based asymmetric family of densities defined in Section 3.2 of Gijbels et al. (2019a).
}
\examples{
# Example 1: Let F be a standard normal cumulative distribution function then
f_N<-function(s){dnorm(s, mean = 0,sd = 1)} # density function of N(0,1)
y<-rnorm(100)
LogLikQBAD(y,mu=0,phi=1,alpha=0.5,f=f_N)

# Example 2: Let F be a standard Laplace cumulative distribution function then
f_La<-function(s){0.5*exp(-abs(s))} # density function of Laplace(0,1)
LogLikQBAD(y,mu=0,phi=1,alpha=0.5,f=f_La)
}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019a). On quantile-based asymmetric family of distributions: properties and inference. \emph{International Statistical Review}, \url{https://doi.org/10.1111/insr.12324}.
}
}
