% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/PyAttach.R
\name{pyAttach}
\alias{pyAttach}
\title{Attach Python objects to R}
\usage{
pyAttach(what, env = parent.frame())
}
\arguments{
\item{what}{a character vector giving the names of the Python objects,
which should be attached to R.}

\item{env}{the environment where the virtual Python objects are
           assigned to.}
}
\description{
A convenience function to attach Python objects to R.
}
\examples{
\dontshow{PythonInR:::pyCranConnect()}
if ( pyIsConnected() ){
pyExec("import os")

## attach to global
## ----------------
## attach the function getcwd from the module os to R.
pyAttach("os.getcwd", .GlobalEnv)
os.getcwd
os.getcwd()
## attach the string object os.name to R
pyAttach("os.name", .GlobalEnv)
pyExecp("os.name")
os.name
## Since os.name is attached to the globalenv it can be set without using
## the global assignment operator
os.name = "Hello Python from R!"
pyExecp("os.name")
os.name
## Please note if you don't pyAttach to globalenv you have to use
## the global assignment operator to set the values of the Python objects

## attach to a new environment
## ---------------------------
os <- new.env()
attach(os, name="python:os")
pyAttach(paste("os", pyDir("os"), sep="."), as.environment("python:os"))
os.sep
os.sep = "new sep" ## this doesn't changes the value in Python but only
                   ## assigns the new variable os.sep to globalenv
os.sep
.GlobalEnv$`os.sep`
as.environment("python:os")$`os.sep`
pyExecp("os.sep")
ls()
ls("python:os")
os.sep <<- "this changes the value in Python"
.GlobalEnv$`os.sep`
as.environment("python:os")$`os.sep`
pyExecp("os.sep")
}
}

