% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive.R
\name{user_cleanup_app}
\alias{user_cleanup_app}
\title{Interactive app for manually cleaning pupil data.}
\usage{
user_cleanup_app(data = data, LogFile = NULL)
}
\arguments{
\item{data}{A data table object.}

\item{LogFile}{A character string indicating the name (and location) of the
log file to be read/written.}
}
\description{
\code{user_cleanup_app} plots current pupil data and allows the user to
select data points which should be removed (changed to NA).  The app saves
a record of the to-be-executed changes in an RDS file.
}
\examples{
if (interactive()) {

# Load example data
data("Pupilex4")

# Writing log file to temporary folder for the example
user_cleanup_app(Pupilex4, LogFile = paste0(tempdir(),"/UserCleanupLog.rds"))
}

# Please see the vignettes for detailed example usage.
# vignette("PupilPre_Cleanup", package="PupilPre")

}
