library('testthat')

library('ProjectTemplate')

# Example 01: CSV Data File
message('Example 01: Testing .csv support')
data.file <- 'example_01'
filename <- file.path(system.file('example_data',
                                  package = 'ProjectTemplate'),
                      'example_01.csv')
variable.name <- ProjectTemplate:::clean.variable.name('example_01')

ProjectTemplate:::csv.reader(data.file, filename, variable.name)

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.01)

# Example 02: CSV Data File with BZip2 Compression
message('Example 02: Testing .csv.bz2 support')
data.file <- 'example_02'
filename <- file.path(system.file('example_data',
                                  package = 'ProjectTemplate'),
                      'example_02.csv.bz2')
variable.name <- ProjectTemplate:::clean.variable.name('example_02')

ProjectTemplate:::csv.reader(data.file, filename, variable.name)

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.02)

# Example 03: CSV Data File with Zip Compression
message('Skipping Example 03: Testing .csv.zip support')

# Example 04: CSV Data File with GZip Compression
message('Example 04: Testing .csv.gz support')
data.file <- 'example_04'
filename <- file.path(system.file('example_data',
                                  package = 'ProjectTemplate'),
                      'example_04.csv.gz')
variable.name <- ProjectTemplate:::clean.variable.name('example_04')

ProjectTemplate:::csv.reader(data.file, filename, variable.name)

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.04)

# Example 05: TSV Data File
message('Example 05: Testing .tsv support')
data.file <- 'example_05'
filename <- file.path(system.file('example_data',
                                  package = 'ProjectTemplate'),
                      'example_05.tsv')
variable.name <- ProjectTemplate:::clean.variable.name('example_05')

ProjectTemplate:::tsv.reader(data.file, filename, variable.name)

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.05)

# Example 06: TSV Data File with BZip2 Compression
message('Example 06: Testing .tsv.bz2 support')
data.file <- 'example_06'
filename <- file.path(system.file('example_data',
                                  package = 'ProjectTemplate'),
                      'example_06.tsv.bz2')
variable.name <- ProjectTemplate:::clean.variable.name('example_06')

ProjectTemplate:::tsv.reader(data.file, filename, variable.name)

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.06)

# Example 07: TSV Data File with Zip Compression
message('Skipping Example 07: Testing .tsv.zip support')

# Example 08: TSV Data File with GZip Compression
message('Example 08: Testing .tsv.gz support')
data.file <- 'example_08'
filename <- file.path(system.file('example_data',
                                  package = 'ProjectTemplate'),
                      'example_08.tsv.gz')
variable.name <- ProjectTemplate:::clean.variable.name('example_08')

ProjectTemplate:::tsv.reader(data.file, filename, variable.name)

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.08)

# Example 09: WSV Data File
message('Example 09: Testing .wsv support')
data.file <- 'example_09'
filename <- file.path(system.file('example_data',
                                  package = 'ProjectTemplate'),
                      'example_09.wsv')
variable.name <- ProjectTemplate:::clean.variable.name('example_09')

ProjectTemplate:::wsv.reader(data.file, filename, variable.name)

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.09)

# Example 10: WSV Data File with BZip2 Compression
message('Example 10: Testing .wsv.bz2 support')
data.file <- 'example_10'
filename <- file.path(system.file('example_data',
                                  package = 'ProjectTemplate'),
                      'example_10.wsv.bz2')
variable.name <- ProjectTemplate:::clean.variable.name('example_10')

ProjectTemplate:::wsv.reader(data.file, filename, variable.name)

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.10)

# Example 11: WSV Data File with Zip Compression
message('Skipping Example 11: Testing .wsv.zip support')

# Example 12: WSV Data File with GZip Compression
message('Example 12: Testing .wsv.gz support')
data.file <- 'example_12'
filename <- file.path(system.file('example_data',
                                  package = 'ProjectTemplate'),
                      'example_12.wsv.gz')
variable.name <- ProjectTemplate:::clean.variable.name('example_12')

ProjectTemplate:::wsv.reader(data.file, filename, variable.name)

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.12)

# Example 13: RData Data File with .RData Extension
message('Example 13: Testing .Rdata support')
data.file <- 'example_13'
filename <- file.path(system.file('example_data',
                                  package = 'ProjectTemplate'),
                      'example_13.RData')
variable.name <- ProjectTemplate:::clean.variable.name('example_13')

ProjectTemplate:::rdata.reader(data.file, filename, variable.name)

expect_that(exists('m'), is_true())
expect_that(names(get('m')), equals(c('N', 'Prime')))
expect_that(nrow(get('m')), equals(5))
expect_that(ncol(get('m')), equals(2))
expect_that(get('m')[5, 2], equals(11))
rm('m')

# Example 14: RData Data File with .rda Extension
message('Example 14: Testing .rda support')
data.file <- 'example_14'
filename <- file.path(system.file('example_data',
                                  package = 'ProjectTemplate'),
                      'example_14.rda')
variable.name <- ProjectTemplate:::clean.variable.name('example_14')

ProjectTemplate:::rdata.reader(data.file, filename, variable.name)

expect_that(exists('n'), is_true())
expect_that(names(get('n')), equals(c('N', 'Prime')))
expect_that(nrow(get('n')), equals(5))
expect_that(ncol(get('n')), equals(2))
expect_that(get('n')[5, 2], equals(11))
rm('n')

# Example 15: URL File with .url Extension

# Example 16: TSV File with .tab Extension
message('Example 16: Testing .tab support')
data.file <- 'example_16'
filename <- file.path(system.file('example_data',
                                  package = 'ProjectTemplate'),
                      'example_16.tab')
variable.name <- ProjectTemplate:::clean.variable.name('example_16')

ProjectTemplate:::tsv.reader(data.file, filename, variable.name)

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.16)

# Example 17: TSV File with .tab Extension and BZip2 Compression
message('Example 17: Testing .tab.bz2 support')
data.file <- 'example_17'
filename <- file.path(system.file('example_data',
                                  package = 'ProjectTemplate'),
                      'example_17.tab.bz2')
variable.name <- ProjectTemplate:::clean.variable.name('example_17')

ProjectTemplate:::tsv.reader(data.file, filename, variable.name)

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.17)

# Example 18: TSV File with .tab Extension and Zip Compression
message('Skipping Example 18: Testing .tab.zip support')

# Example 19: TSV File with .tab Extension and GZip Compression
message('Example 19: Testing .tab.gz support')
data.file <- 'example_19'
filename <- file.path(system.file('example_data',
                                  package = 'ProjectTemplate'),
                      'example_19.tab.gz')
variable.name <- ProjectTemplate:::clean.variable.name('example_19')

ProjectTemplate:::tsv.reader(data.file, filename, variable.name)

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.19)

# Example 20: WSV File with .txt Extension
message('Example 20: Testing .txt support')
data.file <- 'example_20'
filename <- file.path(system.file('example_data',
                                  package = 'ProjectTemplate'),
                      'example_20.txt')
variable.name <- ProjectTemplate:::clean.variable.name('example_20')

ProjectTemplate:::wsv.reader(data.file, filename, variable.name)

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.20)

# Example 21: WSV File with .txt Extension and BZip2 Compression
message('Example 21: Testing .txt.bz2 support')
data.file <- 'example_21'
filename <- file.path(system.file('example_data',
                                  package = 'ProjectTemplate'),
                      'example_21.txt.bz2')
variable.name <- ProjectTemplate:::clean.variable.name('example_21')

ProjectTemplate:::wsv.reader(data.file, filename, variable.name)

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.21)

# Example 22: WSV File with .txt Extension and Zip Compression
message('Skipping Example 22: Testing .txt.zip support')

# Example 23: WSV File with .txt Extension and GZip Compression
message('Example 23: Testing .txt.gz support')
data.file <- 'example_23'
filename <- file.path(system.file('example_data',
                                  package = 'ProjectTemplate'),
                      'example_23.txt.gz')
variable.name <- ProjectTemplate:::clean.variable.name('example_23')

ProjectTemplate:::wsv.reader(data.file, filename, variable.name)

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.23)

# Example 24: R File with .R Extension
message('Example 24: Testing .R support')
data.file <- 'example_24'
filename <- file.path(system.file('example_data',
                                  package = 'ProjectTemplate'),
                      'example_24.R')
variable.name <- ProjectTemplate:::clean.variable.name('example_24')

ProjectTemplate:::r.reader(data.file, filename, variable.name)

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.24)

# Example 25: R File with .r Extension
message('Example 25: Testing .r support')
data.file <- 'example_25'
filename <- file.path(system.file('example_data',
                                  package = 'ProjectTemplate'),
                      'example_25.r')
variable.name <- ProjectTemplate:::clean.variable.name('example_25')

ProjectTemplate:::r.reader(data.file, filename, variable.name)

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.25)

# Example 26: Excel 2007 File with .xls Extension
message('Example 26: Testing .xls support')
data.file <- 'example_26'
filename <- file.path(system.file('example_data',
                                  package = 'ProjectTemplate'),
                      'example_26.xls')
variable.name <- ProjectTemplate:::clean.variable.name('example_26')

ProjectTemplate:::xls.reader(data.file, filename, variable.name)

variable.name <- paste(variable.name, '.Sheet1', sep = '')

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.26.Sheet1)

# Example 27: Excel 2011 File with .xlsx Extension
message('Example 27: Testing .xlsx support')
data.file <- 'example_27'
filename <- file.path(system.file('example_data',
                                  package = 'ProjectTemplate'),
                      'example_27.xlsx')
variable.name <- ProjectTemplate:::clean.variable.name('example_27')

ProjectTemplate:::xlsx.reader(data.file, filename, variable.name)

variable.name <- paste(variable.name, '.Sheet1', sep = '')

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.27.Sheet1)

# Example 28: SQLite3 Support with .sql Extension with table = "..."
message('Example 28: Testing .sql with table = "x" support')
sql.file <- data.frame(type = 'sqlite',
                       dbname = file.path(system.file('example_data',
                                                      package = 'ProjectTemplate'),
                                          'example_28.db'),
                       table = 'example_28')
write.dcf(sql.file, file = 'example_28.sql', width = 1000)

data.file <- 'example_28'
filename <- 'example_28.sql'
variable.name <- ProjectTemplate:::clean.variable.name('example_28')

ProjectTemplate:::sql.reader(data.file, filename, variable.name)

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.28)

# Example 29: SQLite3 Support with .sql Extension with query = "SELECT * FROM ..."
message('Example 29: Testing .sql with query = "x" support')
sql.file <- data.frame(type = 'sqlite',
                       dbname = file.path(system.file('example_data',
                                                      package = 'ProjectTemplate'),
                                          'example_29.db'),
                       query = 'SELECT * FROM example_29')
write.dcf(sql.file, file = 'example_29.sql', width = 1000)

data.file <- 'example_29'
filename <- 'example_29.sql'
variable.name <- ProjectTemplate:::clean.variable.name('example_29')

ProjectTemplate:::sql.reader(data.file, filename, variable.name)

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.29)

# Example 30: SQLite3 Support with .sql Extension and table = "*"
message('Example 30: Testing .sql with table = "*" support')
sql.file <- data.frame(type = 'sqlite',
                       dbname = file.path(system.file('example_data',
                                                      package = 'ProjectTemplate'),
                                          'example_30.db'),
                       table = '*')
write.dcf(sql.file, file = 'example_30.sql', width = 1000)

data.file <- 'example_30'
filename <- 'example_30.sql'
variable.name <- ProjectTemplate:::clean.variable.name('example_30')

ProjectTemplate:::sql.reader(data.file, filename, variable.name)

variable1.name <- ProjectTemplate:::clean.variable.name('example_30a')
variable2.name <- ProjectTemplate:::clean.variable.name('example_30b')
expect_that(exists(variable1.name), is_true())
expect_that(names(get(variable1.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable1.name)), equals(5))
expect_that(ncol(get(variable1.name)), equals(2))
expect_that(get(variable1.name)[5, 2], equals(11))
rm(example.30a)
expect_that(exists(variable2.name), is_true())
expect_that(names(get(variable2.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable2.name)), equals(5))
expect_that(ncol(get(variable2.name)), equals(2))
expect_that(get(variable2.name)[5, 2], equals(11))
rm(example.30b)

# Example 31: SQLite3 Support with .db Extension
message('Example 31: Testing .db support')
data.file <- 'example_31'
filename <- file.path(system.file('example_data',
                                package = 'ProjectTemplate'),
                      'example_31.db')
variable.name <- ProjectTemplate:::clean.variable.name('example_31')

ProjectTemplate:::db.reader(data.file, filename, variable.name)

variable1.name <- ProjectTemplate:::clean.variable.name('example_31a')
variable2.name <- ProjectTemplate:::clean.variable.name('example_31b')
expect_that(exists(variable1.name), is_true())
expect_that(names(get(variable1.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable1.name)), equals(5))
expect_that(ncol(get(variable1.name)), equals(2))
expect_that(get(variable1.name)[5, 2], equals(11))
rm(example.31a)
expect_that(exists(variable2.name), is_true())
expect_that(names(get(variable2.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable2.name)), equals(5))
expect_that(ncol(get(variable2.name)), equals(2))
expect_that(get(variable2.name)[5, 2], equals(11))
rm(example.31b)

# Example 32: Weka Support with .arff Extension
message('Example 32: Testing .arff support')
data.file <- 'example_32'
filename <- file.path(system.file('example_data',
                                package = 'ProjectTemplate'),
                      'example_32.arff')
variable.name <- ProjectTemplate:::clean.variable.name('example_32')

ProjectTemplate:::arff.reader(data.file, filename, variable.name)

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.32)

# Example 33: Arbitary File Support with .file File Pointing to .db File
message('Example 33: Testing .file support')
info.file <- data.frame(path = file.path(system.file('example_data',
                                                      package = 'ProjectTemplate'),
                                          'example_28.db'),
                       extension = 'db')
write.dcf(info.file, file = 'example_33.file', width = 1000)

data.file <- 'example_33'
filename <- 'example_33.file'
variable.name <- ProjectTemplate:::clean.variable.name('example_28')

ProjectTemplate:::file.reader(data.file, filename, variable.name)

expect_that(exists(variable.name), is_true())
expect_that(names(get(variable.name)), equals(c('N', 'Prime')))
expect_that(nrow(get(variable.name)), equals(5))
expect_that(ncol(get(variable.name)), equals(2))
expect_that(get(variable.name)[5, 2], equals(11))
rm(example.28)
