% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreopt_functions.R
\name{inscoreopt}
\alias{inscoreopt}
\title{In-Sample Score Optimisation by Stochastic Gradient Descent}
\usage{
inscoreopt(
  y,
  yhat,
  S,
  Ginit = c(rep(0, ncol(S)), as.vector(solve(t(S) \%*\% S, t(S)))),
  control = list(),
  basedep = "joint",
  basedist = "gaussian",
  Q = 500,
  score = list(score = "energy", alpha = 1),
  trace = FALSE
)
}
\arguments{
\item{y}{Matrix of data, each column responds to an observation, each row corresponds to a variable.}

\item{yhat}{Matrix of predicted values, each column responds to an observation, each row corresponds to a variable.}

\item{S}{Matrix encoding linear constraints.}

\item{Ginit}{Initial values of reconciliation parameters \eqn{d} and \eqn{G} where \eqn{\tilde{y}=S(d+G\hat{y})}.  The first \eqn{m} elements correspond to translation vector \eqn{d}, while the remaining elements correspond to the matrix \eqn{G} where the elements are filled in column-major order. Default is least squares.}

\item{control}{Tuning parameters for SGD. See \code{\link[ProbReco]{scoreopt.control}} for more details}

\item{basedep}{Should base distributions be assumed to be dependent (joint) or independent?  Default is "joint", set to "independent" for independence.}

\item{basedist}{Should base distributions be assumed to be Gaussian or bootstrapped?  Default is "gaussian" set to "bootstrap" for bootstrapping.}

\item{Q}{Number of Monte Carlo iterations used to estimate score}

\item{score}{Score to be used.  This must be a list with two elements: score for the scoring rule (currently only energy supported) and alpha, an additional parameter used in the score (e.g. power in energy score, default is 1).}

\item{trace}{Flag to keep details of SGD.  Default is FALSE}
}
\value{
Optimised reconciliation parameters.
\item{d}{Translation vector for reconciliation.}
\item{G}{Reconciliation matrix (G).}
\item{val}{The estimated optimal total score.}
\item{Gvec_store}{A matrix of Gvec (d and G vectorised) where each column corresponds to an iterate of SGD (only produced when trace=TRUE).}
\item{val_store}{A vector where each element gives the value of the objective function for each iterate of SGD (only produced when trace=TRUE).}
% donttest as elapsed time > 10s
}
\description{
Function to find a reconciliation matrix that optimises total score
using training data.  Stochastic gradient descent is used for optimisation
with gradients found using automatic differentiation. This function differs
from \code{\link[ProbReco]{scoreopt}} in two main ways.  First,
formulation of base probabilistic forecasts is carried out from one of four
options depending on whether dependence and/or Gaussianity is assumed.  Second,
the optimistation is based on in-sample predictions rather than a rolling window
of out-of sample forecasts.  For more flexibility
use \code{\link[ProbReco]{scoreopt}}.
}
\examples{
\donttest{
#Define S matrix
S<-matrix(c(1,1,1,0,0,1),3,2, byrow = TRUE)
#Set data (only 10 training observations used for speed)
y<-S\%*\%(matrix(rnorm(20),2,10)+1)
#Set point forecasts (chosen randomly from (0,1))
yhat<-matrix(runif(nrow(y)*ncol(y)),nrow(y),ncol(y))
#Find weights by SGD (Q set to 20 so that example runs quickly)
out<-inscoreopt(y,yhat,S,Q=20)
}
}
\seealso{
Other ProbReco functions: 
\code{\link{scoreopt.control}()},
\code{\link{scoreopt}()},
\code{\link{total_score}()}
}
\concept{ProbReco functions}
