% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05PTSample.r
\docType{methods}
\name{volume}
\alias{volume}
\alias{volume,PTSample-method}
\alias{volume<-}
\alias{volume<-,PTSample,numeric-method}
\title{Default playback volume of PTSample}
\usage{
\S4method{volume}{PTSample}(sample)

\S4method{volume}{PTSample,numeric}(sample) <- value
}
\arguments{
\item{sample}{A \code{\link{PTSample}} for which the default volume
needs to be extracted or replace.}

\item{value}{A \code{numeric} value ranging from 0 up to 64, representing
the volume level.}
}
\value{
For \code{volume} the volume value, represented by an
\code{integer} value ranging from 0 up to 64, is returned.

For \code{volume<-} A \code{\link{PTSample}} \code{sample}, updated
with the volume \code{value}, is returned.
}
\description{
Extract or replace the default volume of a \code{\link{PTSample}}.
}
\details{
\code{\link{PTSample}}s have a default playback volume, ranging from
\code{0} (silent) up to 64 (maximum volume). This method can be used
to extract this value, or to safely replace it.
}
\examples{
data("mod.intro")

## get the volume of the first sample of mod.intro:

volume(PTSample(mod.intro, 1))

## Let's lower the volume of this sample to 32
## (or as a hexadecimal: 0x20):

volume(PTSample(mod.intro, 1)) <- 0x20

}
\author{
Pepijn de Vries
}
\seealso{
Other sample.operations: \code{\link{PTSample-class}},
  \code{\link{PTSample-method}}, \code{\link{fineTune}},
  \code{\link{loopLength}}, \code{\link{loopSample}},
  \code{\link{loopStart}}, \code{\link{loopState}},
  \code{\link{name}}, \code{\link{playSample}},
  \code{\link{read.sample}}, \code{\link{sampleLength}},
  \code{\link{waveform}}, \code{\link{write.sample}}
}

