% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_votes_by_type.R
\name{get_votes_by_type}
\alias{get_votes_by_type}
\title{Get Votes by Type}
\usage{
get_votes_by_type(
  congress,
  chamber = c("house", "senate"),
  vote_type,
  page = 1,
  myAPI_Key
)
}
\arguments{
\item{congress}{102-116 for House, 80-116 for Senate}

\item{chamber}{house or senate}

\item{vote_type}{missed, party, loneno or perfect}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves a types of votes of each member of a specific chamber and congress.
s
}
\description{
You can get vote information in four categories: missed votes, party votes, lone no votes and perfect votes. Missed votes provides information about the voting attendance of each member of a specific chamber and congress. Party votes provides information about how often each member of a specific chamber and congress votes with a majority of his or her party. Lone no votes provides information lists members in a specific chamber and congress who were the only members to vote No on a roll call vote, and how often that happened. Perfect votes lists members in a specific chamber and congress who voted Yes or No on every vote for which he or she was eligible. HTTP Request: GET https://api.propublica.org/congress/v1/{congress}/{chamber}/votes/{vote-type}.json
}
\examples{
\donttest{
get_votes_by_type(114, 'house', 'missed')
}
}
