% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_top20_candidate_of_FinancialCategory.R
\name{get_top20_candidate_of_FinancialCategory}
\alias{get_top20_candidate_of_FinancialCategory}
\title{Get Top 20 Candidates in Specific Financial Category}
\usage{
get_top20_candidate_of_FinancialCategory(
  category,
  cycle = 2018,
  page = 1,
  myAPI_Key
)
}
\arguments{
\item{category}{One of the values from the following categories:'candidate-loan', 'contribution-total', 'debts-owed', 'disbursements-total', 'end-cash', 'individual-total', 'pac-total', 'receipts-total' and 'refund-total'.}

\item{cycle}{The election cycle}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves a specific FEC candidate for a given campaign cycle.
}
\description{
https://www.propublica.org/datastore/apis
HTTP Request: GET https://api.propublica.org/campaign-finance/v1/{cycle}/candidates/leaders/{category}
}
\examples{
\donttest{
get_top20_candidate_of_FinancialCategory('pac-total', 2016)
}
}
