% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toxFigures.R
\name{toxFigures}
\alias{toxFigures}
\title{Create PRO-CTCAE severity frequency distribution figures for individual
survey items and composite scores}
\usage{
toxFigures(
  dsn,
  id_var,
  cycle_var,
  baseline_val,
  arm_var = NA,
  plot_limit = NA,
  colors = 1,
  label = 0,
  summary_only = FALSE,
  cycles_only = FALSE,
  x_lab_angle = 0,
  x_lab_vjust = 1,
  x_lab_hjust = 0,
  x_label = "Randomized Treatment Assignment",
  plot_data = FALSE
)
}
\arguments{
\item{dsn}{A data.frame object with PRO-CTCAE data}

\item{id_var}{A character string.Name of ID variable differentiating each
PRO-CTCAE survey/participant entered as a quoted string.}

\item{cycle_var}{A character string. Name of variable differentiating one
longitudinal/repeated. PRO-CTCAE survey from another, within an individual
ID.}

\item{baseline_val}{A number indicating the expected baseline cycle/time
point.}

\item{arm_var}{A character string. Name of arm variable differentiating
treatment groups. Must be character or factor class. Overall frequencies
will be reported if no arm/grouping variable is provided. Defaults to
\code{NA}.}

\item{plot_limit}{A number. Limit the number of cycles to be plotted up to
and including a given cycle number. All available cycle time points are
plotted if no cycle number is provided. Defaults to \code{NA}.}

\item{colors}{A number. Specify the coloring scheme of symptom grades within
frequency bars. Options include: 1 = Blue and red color shading, 2 =
qualitative color shades (color blind friendly), 3 = black and white.
Defaults to 1.}

\item{label}{A number. Label frequency bars with sample size (n) or percent
shown on the y-axis. Label options include: \code{1} = sample size (n)
within each cycle (symptom grade 0 or higher), \code{2} = sample size (n)
within each cycle with present symptoms (symptom grade > 0), \code{3} =
sample size (n) within each cycle with severe symptoms (symptom grade >=
3), \code{4} = percent of subjects (%) within each cycle with present
symptoms (symptom grade > 0), \code{5} = percent of subjects within each
cycle with severe symptoms (symptom grade >= 3). No labels will be applied
if not specified. Defaults to \code{NA}.}

\item{summary_only}{Logical. Only display the summary measures in figures /
Suppress the individual time points from plotting. Defaults to
\code{FALSE}.}

\item{cycles_only}{Logical. Only display the longitudinal time points in
figures / Suppress the summary measures from plotting. Defaults to
\code{FALSE}.}

\item{x_lab_angle}{A integer between 0 and 360. Allows the user to rotate the
x axis labels in order to fit long arm names (0 or 45 recommended).
Defaults to \code{0}.}

\item{x_lab_vjust}{A number. A ggplot2 object option. Allows the user to
vertically adjusts the x axis labels in order to fit arm names. Defaults to
\code{1}.}

\item{x_lab_hjust}{A number. A ggplot2 object option. Allows the user to
horizontally adjusts the x axis labels in order to fit arm names. Defaults
to \code{0}.}

\item{x_label}{A character string. Label for the x axis of the plot. Defaults
to \code{"Randomized Treatment Assignment"} if \code{arm_var} is specified,
defaults to \code{"Overall"} if not \code{arm_var} is specified.}

\item{plot_data}{Logical. Return the data used to construct plots as element
of the returned object. Defaults to \code{FALSE}.}
}
\value{
A list object. The returned object is a (k X 2) or (k x 3) nested
  list. Where k is the number of PRO-CTCAE item groups (e.g. pain, fatigue,
  nausea); list[[1 ... i ... k]]. For each list item there are 2 or 3
  elements. The 1st element of each list item is the name of the PRO-CTCAE
  item group returned as a string. The 2nd element is the PRO-CTCAE figure as
  a ggplot object. The 3rd (and optional) element is the data used to
  construct the ggplot figure, available via \code{plot_data}.
}
\description{
Data format should be in 'long' format, where each PRO-CTCAE item is a
	  variable/column.
}
\examples{
# --- Simulate example PRO-CTCAE data
fig_acute = toxFigures(dsn = ProAE::tox_acute,
 cycle_var = "Cycle",
 baseline_val = 1,
 arm_var = "arm",
 id_var = "id",
 label = 0,
 x_lab_angle = -45,
 x_lab_vjust =  .3,
 x_lab_hjust = .2,
 colors = 2)
fig_acute[[1]]
}
